/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.nifi.cluster.protocol.ProtocolContext;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.ProtocolMessageMarshaller;
import org.apache.nifi.cluster.protocol.impl.MulticastProtocolListener;
import org.apache.nifi.cluster.protocol.jaxb.JaxbProtocolContext;
import org.apache.nifi.cluster.protocol.jaxb.message.JaxbProtocolUtils;
import org.apache.nifi.cluster.protocol.message.PingMessage;
import org.apache.nifi.cluster.protocol.message.ProtocolMessage;
import org.apache.nifi.io.socket.multicast.MulticastConfiguration;
import org.apache.nifi.io.socket.multicast.MulticastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastTestClient {
    private static final Logger logger = LoggerFactory.getLogger(MulticastTestClient.class);
    private static final int PING_DELAY_SECONDS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws IOException {
        int port;
        String group = System.getProperty("group", "225.0.0.0");
        if (group == null) {
            System.out.println("Host system property 'group' was not given.");
            return;
        }
        if ((group = group.trim()).length() == 0) {
            System.out.println("Host system property 'group' must be non-empty.");
            return;
        }
        String portStr = System.getProperty("port", "2222");
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Port system property 'port' was not a valid port.");
            return;
        }
        logger.info(String.format("Pinging every %s seconds using multicast address: %s:%s.", 3, group, port));
        logger.info("Override defaults by using system properties '-Dgroup=<Class D IP>' and '-Dport=<unused port>'.");
        logger.info("The test client may be stopped by entering a newline at the command line.");
        InetSocketAddress addr = new InetSocketAddress(group, port);
        JaxbProtocolContext protocolContext = new JaxbProtocolContext(JaxbProtocolUtils.JAXB_CONTEXT);
        MulticastConfiguration multicastConfig = new MulticastConfiguration();
        multicastConfig.setReuseAddress(Boolean.valueOf(true));
        MulticastProtocolListener listener = new MulticastProtocolListener(1, addr, multicastConfig, (ProtocolContext)protocolContext);
        listener.addHandler(new ProtocolHandler(){

            public ProtocolMessage handle(ProtocolMessage msg) throws ProtocolException {
                PingMessage pingMsg = (PingMessage)msg;
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss", Locale.US);
                logger.info("Pinged at: " + sdf.format(pingMsg.getDate()));
                return null;
            }

            public boolean canHandle(ProtocolMessage msg) {
                return true;
            }
        });
        MulticastSocket multicastSocket = MulticastUtils.createMulticastSocket((MulticastConfiguration)multicastConfig);
        Timer broadcaster = new Timer("Multicast Test Client", true);
        try {
            listener.start();
            broadcaster.schedule(new TimerTask((ProtocolContext)protocolContext, addr, multicastSocket){
                final /* synthetic */ ProtocolContext val$protocolContext;
                final /* synthetic */ InetSocketAddress val$addr;
                final /* synthetic */ MulticastSocket val$multicastSocket;
                {
                    this.val$protocolContext = protocolContext;
                    this.val$addr = inetSocketAddress;
                    this.val$multicastSocket = multicastSocket;
                }

                @Override
                public void run() {
                    try {
                        PingMessage msg = new PingMessage();
                        msg.setDate(new Date());
                        ProtocolMessageMarshaller marshaller = this.val$protocolContext.createMarshaller();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        marshaller.marshal((Object)msg, (OutputStream)baos);
                        byte[] packetBytes = baos.toByteArray();
                        DatagramPacket packet = new DatagramPacket(packetBytes, packetBytes.length, this.val$addr);
                        this.val$multicastSocket.send(packet);
                    }
                    catch (Exception ex) {
                        logger.warn("Failed to send message due to: " + ex, (Throwable)ex);
                    }
                }
            }, 0L, 3000L);
            System.in.read();
        }
        finally {
            broadcaster.cancel();
            if (listener.isRunning()) {
                listener.stop();
            }
        }
    }
}

