/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.entity.DropRequestEntity;

public class DropRequestEndpiontMerger
extends AbstractSingleDTOEndpoint<DropRequestEntity, DropRequestDTO> {
    public static final Pattern DROP_REQUESTS_URI = Pattern.compile("/nifi-api/flowfile-queues/[a-f0-9\\-]{36}/drop-requests");
    public static final Pattern DROP_REQUEST_URI = Pattern.compile("/nifi-api/flowfile-queues/[a-f0-9\\-]{36}/drop-requests/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) && DROP_REQUEST_URI.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && DROP_REQUESTS_URI.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<DropRequestEntity> getEntityClass() {
        return DropRequestEntity.class;
    }

    @Override
    protected DropRequestDTO getDto(DropRequestEntity entity) {
        return entity.getDropRequest();
    }

    @Override
    protected void mergeResponses(DropRequestDTO clientDto, Map<NodeIdentifier, DropRequestDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        boolean nodeWaiting = false;
        int originalCount = 0;
        long originalSize = 0L;
        int currentCount = 0;
        long currentSize = 0L;
        int droppedCount = 0;
        long droppedSize = 0L;
        DropFlowFileState state = null;
        boolean allFinished = true;
        String failureReason = null;
        for (Map.Entry<NodeIdentifier, DropRequestDTO> nodeEntry : dtoMap.entrySet()) {
            DropRequestDTO nodeDropRequest = nodeEntry.getValue();
            if (!nodeDropRequest.isFinished().booleanValue()) {
                allFinished = false;
            }
            if (nodeDropRequest.getFailureReason() != null) {
                failureReason = nodeDropRequest.getFailureReason();
            }
            currentCount += nodeDropRequest.getCurrentCount().intValue();
            currentSize += nodeDropRequest.getCurrentSize().longValue();
            droppedCount += nodeDropRequest.getDroppedCount().intValue();
            droppedSize += nodeDropRequest.getDroppedSize().longValue();
            if (nodeDropRequest.getOriginalCount() == null) {
                nodeWaiting = true;
            } else {
                originalCount += nodeDropRequest.getOriginalCount().intValue();
                originalSize += nodeDropRequest.getOriginalSize().longValue();
            }
            DropFlowFileState nodeState = DropFlowFileState.valueOfDescription((String)nodeDropRequest.getState());
            if (state != null && state.ordinal() <= nodeState.ordinal()) continue;
            state = nodeState;
        }
        clientDto.setCurrentCount(Integer.valueOf(currentCount));
        clientDto.setCurrentSize(Long.valueOf(currentSize));
        clientDto.setCurrent(FormatUtils.formatCount((long)currentCount) + " / " + FormatUtils.formatDataSize((double)currentSize));
        clientDto.setDroppedCount(Integer.valueOf(droppedCount));
        clientDto.setDroppedSize(Long.valueOf(droppedSize));
        clientDto.setDropped(FormatUtils.formatCount((long)droppedCount) + " / " + FormatUtils.formatDataSize((double)droppedSize));
        clientDto.setFinished(Boolean.valueOf(allFinished));
        clientDto.setFailureReason(failureReason);
        if (originalCount == 0) {
            clientDto.setPercentCompleted(Integer.valueOf(allFinished ? 100 : 0));
        } else {
            clientDto.setPercentCompleted(Integer.valueOf((int)((double)droppedCount / (double)originalCount * 100.0)));
        }
        if (!nodeWaiting) {
            clientDto.setOriginalCount(Integer.valueOf(originalCount));
            clientDto.setOriginalSize(Long.valueOf(originalSize));
            clientDto.setOriginal(FormatUtils.formatCount((long)originalCount) + " / " + FormatUtils.formatDataSize((double)originalSize));
        }
        if (state != null) {
            clientDto.setState(state.toString());
        }
    }
}

