/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.TemplateEntity;
import org.apache.nifi.web.api.entity.TemplatesEntity;

public class TemplatesEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern TEMPLATES_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/templates");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && TEMPLATES_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    protected Class<TemplatesEntity> getEntityClass() {
        return TemplatesEntity.class;
    }

    protected Set<TemplateEntity> getDtos(TemplatesEntity entity) {
        return entity.getTemplates();
    }

    protected String getComponentId(TemplateDTO dto) {
        return dto.getId();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        TemplatesEntity responseEntity = (TemplatesEntity)clientResponse.getClientResponse().getEntity(this.getEntityClass());
        HashMap<String, TemplateEntity> templatesById = null;
        for (NodeResponse nodeResponse : successfulResponses) {
            TemplatesEntity entity = nodeResponse == clientResponse ? responseEntity : (TemplatesEntity)nodeResponse.getClientResponse().getEntity(TemplatesEntity.class);
            Set templateEntities = entity.getTemplates();
            Map<String, TemplateEntity> nodeTemplatesById = templateEntities.stream().collect(Collectors.toMap(ent -> ent.getId(), ent -> ent));
            if (templatesById == null) {
                templatesById = new HashMap<String, TemplateEntity>(nodeTemplatesById);
                continue;
            }
            templatesById.keySet().retainAll(nodeTemplatesById.keySet());
        }
        responseEntity.setTemplates(new HashSet(templatesById.values()));
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

