/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.BulletinEntity;

public final class BulletinMerger {
    public static Comparator<BulletinEntity> BULLETIN_COMPARATOR = new Comparator<BulletinEntity>(){

        @Override
        public int compare(BulletinEntity o1, BulletinEntity o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return -Long.compare(o1.getId(), o2.getId());
        }
    };

    private BulletinMerger() {
    }

    public static List<BulletinEntity> mergeBulletins(Map<NodeIdentifier, List<BulletinEntity>> bulletins) {
        ArrayList<BulletinEntity> bulletinEntities = new ArrayList<BulletinEntity>();
        for (Map.Entry<NodeIdentifier, List<BulletinEntity>> entry : bulletins.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            List<BulletinEntity> nodeBulletins = entry.getValue();
            String nodeAddress = nodeId.getApiAddress() + ":" + nodeId.getApiPort();
            for (BulletinEntity bulletinEntity : nodeBulletins) {
                if (bulletinEntity.getNodeAddress() == null) {
                    bulletinEntity.setNodeAddress(nodeAddress);
                }
                if (bulletinEntity.getCanRead().booleanValue() && bulletinEntity.getBulletin() != null && bulletinEntity.getBulletin().getNodeAddress() == null) {
                    bulletinEntity.getBulletin().setNodeAddress(nodeAddress);
                }
                bulletinEntities.add(bulletinEntity);
            }
        }
        Collections.sort(bulletinEntities, (o1, o2) -> {
            int timeComparison = o1.getTimestamp().compareTo(o2.getTimestamp());
            if (timeComparison != 0) {
                return timeComparison;
            }
            return o1.getNodeAddress().compareTo(o2.getNodeAddress());
        });
        return bulletinEntities;
    }
}

