/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.http.HttpResponseMapper;
import org.apache.nifi.cluster.coordination.http.replication.AsyncClusterResponse;
import org.apache.nifi.cluster.coordination.http.replication.CompletionCallback;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAsyncClusterResponse
implements AsyncClusterResponse {
    private static final Logger logger = LoggerFactory.getLogger(StandardAsyncClusterResponse.class);
    private final String id;
    private final Set<NodeIdentifier> nodeIds;
    private final URI uri;
    private final String method;
    private final HttpResponseMapper responseMapper;
    private final CompletionCallback completionCallback;
    private final Runnable completedResultFetchedCallback;
    private final long creationTimeNanos;
    private final boolean merge;
    private final Map<NodeIdentifier, ResponseHolder> responseMap = new HashMap<NodeIdentifier, ResponseHolder>();
    private final AtomicInteger requestsCompleted = new AtomicInteger(0);
    private NodeResponse mergedResponse;
    private RuntimeException failure;

    public StandardAsyncClusterResponse(String id, URI uri, String method, Set<NodeIdentifier> nodeIds, HttpResponseMapper responseMapper, CompletionCallback completionCallback, Runnable completedResultFetchedCallback, boolean merge) {
        this.id = id;
        this.nodeIds = Collections.unmodifiableSet(new HashSet<NodeIdentifier>(nodeIds));
        this.uri = uri;
        this.method = method;
        this.merge = merge;
        this.creationTimeNanos = System.nanoTime();
        for (NodeIdentifier nodeId : nodeIds) {
            this.responseMap.put(nodeId, new ResponseHolder(this.creationTimeNanos));
        }
        this.responseMapper = responseMapper;
        this.completionCallback = completionCallback;
        this.completedResultFetchedCallback = completedResultFetchedCallback;
    }

    @Override
    public String getRequestIdentifier() {
        return this.id;
    }

    @Override
    public Set<NodeIdentifier> getNodesInvolved() {
        return this.nodeIds;
    }

    @Override
    public Set<NodeIdentifier> getCompletedNodeIdentifiers() {
        return this.responseMap.entrySet().stream().filter(entry -> ((ResponseHolder)entry.getValue()).isComplete()).map(entry -> (NodeIdentifier)entry.getKey()).collect(Collectors.toSet());
    }

    @Override
    public Set<NodeResponse> getCompletedNodeResponses() {
        return this.responseMap.values().stream().filter(responseHolder -> responseHolder.isComplete()).map(responseHolder -> responseHolder.getResponse()).collect(Collectors.toSet());
    }

    @Override
    public boolean isOlderThan(long time, TimeUnit timeUnit) {
        long nanos = timeUnit.toNanos(time);
        long threshold = System.nanoTime() - nanos;
        return this.creationTimeNanos < threshold;
    }

    @Override
    public boolean isComplete() {
        return this.getMergedResponse() != null;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getURIPath() {
        return this.uri.getPath();
    }

    @Override
    public NodeResponse getMergedResponse() {
        return this.getMergedResponse(true);
    }

    public synchronized NodeResponse getMergedResponse(boolean triggerCallback) {
        if (this.failure != null) {
            throw this.failure;
        }
        if (this.mergedResponse != null) {
            if (triggerCallback && this.completedResultFetchedCallback != null) {
                this.completedResultFetchedCallback.run();
            }
            return this.mergedResponse;
        }
        if (this.requestsCompleted.get() < this.responseMap.size()) {
            return null;
        }
        Set<NodeResponse> nodeResponses = this.responseMap.values().stream().map(p -> p.getResponse()).filter(response -> response != null).collect(Collectors.toSet());
        this.mergedResponse = this.responseMapper.mapResponses(this.uri, this.method, nodeResponses, this.merge);
        logger.debug("Notifying all that merged response is complete for {}", (Object)this.id);
        this.notifyAll();
        if (triggerCallback && this.completedResultFetchedCallback != null) {
            this.completedResultFetchedCallback.run();
        }
        return this.mergedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeResponse awaitMergedResponse() throws InterruptedException {
        StandardAsyncClusterResponse standardAsyncClusterResponse = this;
        synchronized (standardAsyncClusterResponse) {
            while (this.getMergedResponse(false) == null) {
                logger.debug("Waiting indefinitely for merged response to be complete for {}", (Object)this.id);
                this.wait();
            }
        }
        return this.getMergedResponse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeResponse awaitMergedResponse(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        long maxTime = System.nanoTime() + timeUnit.toNanos(timeout);
        StandardAsyncClusterResponse standardAsyncClusterResponse = this;
        synchronized (standardAsyncClusterResponse) {
            while (this.getMergedResponse(false) == null) {
                long nanosToWait = maxTime - System.nanoTime();
                if (nanosToWait < 0L) {
                    return this.getMergedResponse(true);
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(nanosToWait);
                int nanos = (int)(nanosToWait - TimeUnit.MILLISECONDS.toNanos(millis));
                logger.debug("Waiting {} millis and {} nanos for merged response to be complete for {}", new Object[]{millis, nanos, this.id});
                this.wait(millis, nanos);
            }
        }
        return this.getMergedResponse(true);
    }

    @Override
    public NodeResponse getNodeResponse(NodeIdentifier nodeId) {
        ResponseHolder request = this.responseMap.get(nodeId);
        return request == null ? null : request.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(NodeResponse nodeResponse) {
        ResponseHolder responseHolder = this.responseMap.get(nodeResponse.getNodeId());
        if (responseHolder == null) {
            throw new IllegalStateException("Node " + nodeResponse.getNodeId() + " is not known for this request");
        }
        responseHolder.setResponse(nodeResponse);
        int completedCount = this.requestsCompleted.incrementAndGet();
        logger.debug("Received response {} out of {} for {} from {}", new Object[]{completedCount, this.responseMap.size(), this.id, nodeResponse.getNodeId()});
        if (completedCount == this.responseMap.size()) {
            logger.debug("Notifying all that merged response is ready for {}", (Object)this.id);
            StandardAsyncClusterResponse standardAsyncClusterResponse = this;
            synchronized (standardAsyncClusterResponse) {
                this.notifyAll();
            }
            if (this.completionCallback != null) {
                this.completionCallback.onCompletion(this);
            }
        }
    }

    synchronized void setFailure(RuntimeException failure) {
        this.failure = failure;
        this.notifyAll();
        if (this.completionCallback != null) {
            this.completionCallback.onCompletion(this);
        }
    }

    public String toString() {
        return "StandardAsyncClusterResponse[id=" + this.id + ", uri=" + this.uri + ", method=" + this.method + ", failure=" + (this.failure != null) + ", responses=" + this.getCompletedNodeIdentifiers().size() + "/" + this.responseMap.size() + "]";
    }

    private static class ResponseHolder {
        private final long nanoStart;
        private long requestNanos;
        private NodeResponse response;

        public ResponseHolder(long startNanos) {
            this.nanoStart = startNanos;
        }

        public synchronized void setResponse(NodeResponse response) {
            this.response = response;
            this.requestNanos = System.nanoTime() - this.nanoStart;
        }

        public synchronized NodeResponse getResponse() {
            return this.response;
        }

        public synchronized boolean isComplete() {
            return this.response != null;
        }

        public long getRequestDuration(TimeUnit timeUnit) {
            return timeUnit.toNanos(this.requestNanos);
        }
    }
}

