/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.entity.PortEntity;

public class PortEntityMerger
implements ComponentEntityMerger<PortEntity>,
ComponentEntityStatusMerger<PortStatusDTO> {
    @Override
    public void merge(PortEntity clientEntity, Map<NodeIdentifier, PortEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
        for (Map.Entry<NodeIdentifier, PortEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            PortEntity entityStatus = entry.getValue();
            if (entityStatus == clientEntity) continue;
            this.mergeStatus(clientEntity.getStatus(), (boolean)clientEntity.getPermissions().getCanRead(), entry.getValue().getStatus(), (boolean)entry.getValue().getPermissions().getCanRead(), entry.getKey());
        }
    }

    @Override
    public void mergeComponents(PortEntity clientEntity, Map<NodeIdentifier, PortEntity> entityMap) {
        PortDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, PortDTO> dtoMap = new HashMap<NodeIdentifier, PortDTO>();
        for (Map.Entry<NodeIdentifier, PortEntity> entry : entityMap.entrySet()) {
            PortEntity nodePortEntity = entry.getValue();
            PortDTO nodePortDto = nodePortEntity.getComponent();
            dtoMap.put(entry.getKey(), nodePortDto);
        }
        PortEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    @Override
    public void mergeStatus(PortStatusDTO clientStatus, boolean clientStatusReadablePermission, PortStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }

    private static void mergeDtos(PortDTO clientDto, Map<NodeIdentifier, PortDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        for (Map.Entry<NodeIdentifier, PortDTO> nodeEntry : dtoMap.entrySet()) {
            PortDTO nodePort = nodeEntry.getValue();
            if (nodePort == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodePort.getValidationErrors());
        }
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }
}

