/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;

public abstract class AbstractSingleEntityEndpoint<EntityType extends Entity>
implements EndpointResponseMerger {
    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        Entity responseEntity = (Entity)clientResponse.getClientResponse().getEntity(this.getEntityClass());
        HashMap<NodeIdentifier, Entity> entityMap = new HashMap<NodeIdentifier, Entity>();
        for (NodeResponse nodeResponse : successfulResponses) {
            Entity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (Entity)nodeResponse.getClientResponse().getEntity(this.getEntityClass());
            entityMap.put(nodeResponse.getNodeId(), nodeResponseEntity);
        }
        this.mergeResponses(responseEntity, entityMap, successfulResponses, problematicResponses);
        return new NodeResponse(clientResponse, responseEntity);
    }

    protected abstract Class<EntityType> getEntityClass();

    protected abstract void mergeResponses(EntityType var1, Map<NodeIdentifier, EntityType> var2, Set<NodeResponse> var3, Set<NodeResponse> var4);
}

