/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PortEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.entity.ControllerEntity;

public class ControllerEndpointMerger
extends AbstractSingleDTOEndpoint<ControllerEntity, ControllerDTO> {
    public static final Pattern CONTROLLER_URI_PATTERN = Pattern.compile("/nifi-api/site-to-site");
    private PortEntityMerger portMerger = new PortEntityMerger();

    @Override
    protected Class<ControllerEntity> getEntityClass() {
        return ControllerEntity.class;
    }

    @Override
    protected ControllerDTO getDto(ControllerEntity entity) {
        return entity.getController();
    }

    @Override
    protected void mergeResponses(ControllerDTO clientDto, Map<NodeIdentifier, ControllerDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ControllerDTO mergedController = clientDto;
        HashMap inputPortMap = new HashMap();
        HashMap outputPortMap = new HashMap();
        for (Map.Entry<NodeIdentifier, ControllerDTO> entry : dtoMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ControllerDTO nodeController = entry.getValue();
            nodeController.getInputPorts().stream().forEach(inputPort -> inputPortMap.computeIfAbsent(inputPort.getId(), nodeIdToInputPort -> new HashMap()).put(nodeId, inputPort));
            nodeController.getOutputPorts().stream().forEach(outputPort -> outputPortMap.computeIfAbsent(outputPort.getId(), nodeIdToOutputPort -> new HashMap()).put(nodeId, outputPort));
        }
        for (Map inputPortByNodeId : inputPortMap.values()) {
            Collection nodeInputPorts = inputPortByNodeId.values();
            if (nodeInputPorts.isEmpty()) continue;
            PortDTO inputPort2 = (PortDTO)nodeInputPorts.iterator().next();
            PortDTO clientInputPort = clientDto.getInputPorts().stream().filter(p -> p.getId().equals(inputPort2.getId())).findFirst().orElse(null);
            if (clientInputPort == null) continue;
            PortEntityMerger.mergeDtos(clientInputPort, inputPortByNodeId);
        }
        for (Map outputPortByNodeId : outputPortMap.values()) {
            Collection nodeOutputPorts = outputPortByNodeId.values();
            if (nodeOutputPorts.isEmpty()) continue;
            PortDTO outputPort2 = (PortDTO)nodeOutputPorts.iterator().next();
            PortDTO clientOutputPort = clientDto.getInputPorts().stream().filter(p -> p.getId().equals(outputPort2.getId())).findFirst().orElse(null);
            if (clientOutputPort == null) continue;
            PortEntityMerger.mergeDtos(clientOutputPort, outputPortByNodeId);
        }
        HashSet clientInputPorts = Sets.newHashSet((Iterable)clientDto.getInputPorts());
        HashSet clientOutputPorts = Sets.newHashSet((Iterable)clientDto.getOutputPorts());
        dtoMap.values().forEach(controller -> {
            clientInputPorts.retainAll(controller.getInputPorts());
            clientOutputPorts.retainAll(controller.getOutputPorts());
        });
        clientDto.setInputPorts((Set)clientInputPorts);
        clientDto.setInputPortCount(Integer.valueOf(clientInputPorts.size()));
        clientDto.setOutputPorts((Set)clientOutputPorts);
        clientDto.setOutputPortCount(Integer.valueOf(clientOutputPorts.size()));
    }

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && CONTROLLER_URI_PATTERN.matcher(uri.getPath()).matches();
    }
}

