/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.ReportingTaskEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;

public class ReportingTaskEndpointMerger
extends AbstractSingleEntityEndpoint<ReportingTaskEntity>
implements EndpointResponseMerger {
    public static final String REPORTING_TASKS_URI = "/nifi-api/controller/reporting-tasks";
    public static final Pattern REPORTING_TASK_URI_PATTERN = Pattern.compile("/nifi-api/reporting-tasks/[a-f0-9\\-]{36}");
    private final ReportingTaskEntityMerger reportingTaskEntityMerger = new ReportingTaskEntityMerger();

    @Override
    public boolean canHandle(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && REPORTING_TASK_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && REPORTING_TASKS_URI.equals(uri.getPath());
    }

    @Override
    protected Class<ReportingTaskEntity> getEntityClass() {
        return ReportingTaskEntity.class;
    }

    @Override
    protected void mergeResponses(ReportingTaskEntity clientEntity, Map<NodeIdentifier, ReportingTaskEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        this.reportingTaskEntityMerger.merge(clientEntity, entityMap);
    }
}

