/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.PropertyDescriptorDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;

public class ReportingTaskEntityMerger
implements ComponentEntityMerger<ReportingTaskEntity> {
    @Override
    public void mergeComponents(ReportingTaskEntity clientEntity, Map<NodeIdentifier, ReportingTaskEntity> entityMap) {
        ReportingTaskDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, ReportingTaskDTO> dtoMap = new HashMap<NodeIdentifier, ReportingTaskDTO>();
        for (Map.Entry<NodeIdentifier, ReportingTaskEntity> entry : entityMap.entrySet()) {
            ReportingTaskEntity nodeReportingTaskEntity = entry.getValue();
            ReportingTaskDTO nodeReportingTaskDto = nodeReportingTaskEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeReportingTaskDto);
        }
        ReportingTaskEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    private static void mergeDtos(ReportingTaskDTO clientDto, Map<NodeIdentifier, ReportingTaskDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        HashMap propertyDescriptorMap = new HashMap();
        int activeThreadCount = 0;
        for (Map.Entry<NodeIdentifier, ReportingTaskDTO> nodeEntry : dtoMap.entrySet()) {
            ReportingTaskDTO nodeReportingTask = nodeEntry.getValue();
            if (nodeReportingTask == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            if (nodeReportingTask.getActiveThreadCount() != null) {
                activeThreadCount += nodeReportingTask.getActiveThreadCount().intValue();
            }
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodeReportingTask.getValidationErrors());
            nodeReportingTask.getDescriptors().values().stream().forEach(propertyDescriptor -> propertyDescriptorMap.computeIfAbsent(propertyDescriptor.getName(), nodeIdToPropertyDescriptor -> new HashMap()).put(nodeId, propertyDescriptor));
        }
        for (Map propertyDescriptorByNodeId : propertyDescriptorMap.values()) {
            Collection nodePropertyDescriptors = propertyDescriptorByNodeId.values();
            if (nodePropertyDescriptors.isEmpty()) continue;
            PropertyDescriptorDTO propertyDescriptor2 = (PropertyDescriptorDTO)nodePropertyDescriptors.iterator().next();
            PropertyDescriptorDTO clientPropertyDescriptor = (PropertyDescriptorDTO)clientDto.getDescriptors().get(propertyDescriptor2.getName());
            PropertyDescriptorDtoMerger.merge(clientPropertyDescriptor, propertyDescriptorByNodeId);
        }
        clientDto.setActiveThreadCount(Integer.valueOf(activeThreadCount));
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }
}

