/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.status.NodeProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.entity.ProcessorStatusEntity;

public class ProcessorStatusEndpointMerger
extends AbstractSingleEntityEndpoint<ProcessorStatusEntity>
implements ComponentEntityStatusMerger<ProcessorStatusDTO> {
    public static final Pattern PROCESSOR_STATUS_URI_PATTERN = Pattern.compile("/nifi-api/flow/processors/[a-f0-9\\-]{36}/status");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PROCESSOR_STATUS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ProcessorStatusEntity> getEntityClass() {
        return ProcessorStatusEntity.class;
    }

    @Override
    protected void mergeResponses(ProcessorStatusEntity clientEntity, Map<NodeIdentifier, ProcessorStatusEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ProcessorStatusDTO mergedProcessorStatus = clientEntity.getProcessorStatus();
        mergedProcessorStatus.setNodeSnapshots(new ArrayList());
        NodeIdentifier selectedNodeId = entityMap.entrySet().stream().filter(e -> e.getValue() == clientEntity).map(e -> (NodeIdentifier)e.getKey()).findFirst().orElse(null);
        NodeProcessorStatusSnapshotDTO selectedNodeSnapshot = new NodeProcessorStatusSnapshotDTO();
        selectedNodeSnapshot.setStatusSnapshot(mergedProcessorStatus.getAggregateSnapshot().clone());
        selectedNodeSnapshot.setAddress(selectedNodeId.getApiAddress());
        selectedNodeSnapshot.setApiPort(Integer.valueOf(selectedNodeId.getApiPort()));
        selectedNodeSnapshot.setNodeId(selectedNodeId.getId());
        mergedProcessorStatus.getNodeSnapshots().add(selectedNodeSnapshot);
        for (Map.Entry<NodeIdentifier, ProcessorStatusEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ProcessorStatusEntity nodeProcessorStatusEntity = entry.getValue();
            ProcessorStatusDTO nodeProcessorStatus = nodeProcessorStatusEntity.getProcessorStatus();
            if (nodeProcessorStatus == mergedProcessorStatus) continue;
            this.mergeStatus(mergedProcessorStatus, (boolean)clientEntity.getCanRead(), nodeProcessorStatus, (boolean)nodeProcessorStatusEntity.getCanRead(), nodeId);
        }
    }

    @Override
    public void mergeStatus(ProcessorStatusDTO clientStatus, boolean clientStatusReadablePermission, ProcessorStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }
}

