/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.UserGroupsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.UserGroupEntity;
import org.apache.nifi.web.api.entity.UserGroupsEntity;

public class UserGroupsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern USER_GROUPS_URI_PATTERN = Pattern.compile("/nifi-api/tenants/user-groups");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && USER_GROUPS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        UserGroupsEntity responseEntity = (UserGroupsEntity)clientResponse.getClientResponse().readEntity(UserGroupsEntity.class);
        Collection userGroupEntities = responseEntity.getUserGroups();
        HashMap<String, Map<NodeIdentifier, UserGroupEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, UserGroupEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            UserGroupsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (UserGroupsEntity)nodeResponse.getClientResponse().readEntity(UserGroupsEntity.class);
            Collection nodeUserGroupEntities = nodeResponseEntity.getUserGroups();
            userGroupEntities.retainAll(nodeUserGroupEntities);
            for (UserGroupEntity nodeUserGroupEntity : nodeUserGroupEntities) {
                NodeIdentifier nodeId = nodeResponse.getNodeId();
                HashMap<NodeIdentifier, UserGroupEntity> innerMap = (HashMap<NodeIdentifier, UserGroupEntity>)entityMap.get(nodeId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, UserGroupEntity>();
                    entityMap.put(nodeUserGroupEntity.getId(), innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodeUserGroupEntity);
            }
        }
        UserGroupsEntityMerger.mergeUserGroups(userGroupEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

