/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.coordination.http.endpoints.ConfigVerificationResultMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.VerifyConfigRequestDTO;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;

public class VerifyConfigEndpointMerger
extends AbstractSingleEntityEndpoint<VerifyConfigRequestEntity> {
    public static final Pattern VERIFY_PROCESSOR_CONFIG_URI_PATTERN = Pattern.compile("/nifi-api/processors/[a-f0-9\\-]{36}/config/verification-requests(/[a-f0-9\\-]{36})?");
    public static final Pattern VERIFY_CONTROLLER_SERVICE_CONFIG_URI_PATTERN = Pattern.compile("/nifi-api/controller-services/[a-f0-9\\-]{36}/config/verification-requests(/[a-f0-9\\-]{36})?");
    public static final Pattern VERIFY_REPORTING_TASK_CONFIG_URI_PATTERN = Pattern.compile("/nifi-api/reporting-tasks/[a-f0-9\\-]{36}/config/verification-requests(/[a-f0-9\\-]{36})?");

    @Override
    protected Class<VerifyConfigRequestEntity> getEntityClass() {
        return VerifyConfigRequestEntity.class;
    }

    @Override
    public boolean canHandle(URI uri, String method) {
        return VERIFY_PROCESSOR_CONFIG_URI_PATTERN.matcher(uri.getPath()).matches() || VERIFY_CONTROLLER_SERVICE_CONFIG_URI_PATTERN.matcher(uri.getPath()).matches() || VERIFY_REPORTING_TASK_CONFIG_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected void mergeResponses(VerifyConfigRequestEntity clientEntity, Map<NodeIdentifier, VerifyConfigRequestEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        VerifyConfigRequestDTO requestDto = clientEntity.getRequest();
        List results = requestDto.getResults();
        if (results == null) {
            return;
        }
        ConfigVerificationResultMerger resultMerger = new ConfigVerificationResultMerger();
        for (Map.Entry<NodeIdentifier, VerifyConfigRequestEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            VerifyConfigRequestEntity entity = entry.getValue();
            List nodeResults = entity.getRequest().getResults();
            resultMerger.addNodeResults(nodeId, nodeResults);
        }
        List<ConfigVerificationResultDTO> aggregateResults = resultMerger.computeAggregateResults();
        clientEntity.getRequest().setResults(aggregateResults);
    }
}

