/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractNodeStatusEndpoint;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.NodeSystemDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.entity.SystemDiagnosticsEntity;

public class SystemDiagnosticsEndpointMerger
extends AbstractNodeStatusEndpoint<SystemDiagnosticsEntity, SystemDiagnosticsDTO> {
    public static final Pattern SYSTEM_DIAGNOSTICS_URI_PATTERN = Pattern.compile("/nifi-api/system-diagnostics");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && SYSTEM_DIAGNOSTICS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<SystemDiagnosticsEntity> getEntityClass() {
        return SystemDiagnosticsEntity.class;
    }

    @Override
    protected SystemDiagnosticsDTO getDto(SystemDiagnosticsEntity entity) {
        return entity.getSystemDiagnostics();
    }

    @Override
    protected void mergeResponses(SystemDiagnosticsDTO clientDto, Map<NodeIdentifier, SystemDiagnosticsDTO> dtoMap, NodeIdentifier selectedNodeId) {
        SystemDiagnosticsDTO mergedSystemDiagnostics = clientDto;
        mergedSystemDiagnostics.setNodeSnapshots(new ArrayList());
        NodeSystemDiagnosticsSnapshotDTO selectedNodeSnapshot = new NodeSystemDiagnosticsSnapshotDTO();
        selectedNodeSnapshot.setSnapshot(clientDto.getAggregateSnapshot().clone());
        selectedNodeSnapshot.setAddress(selectedNodeId.getApiAddress());
        selectedNodeSnapshot.setApiPort(Integer.valueOf(selectedNodeId.getApiPort()));
        selectedNodeSnapshot.setNodeId(selectedNodeId.getId());
        mergedSystemDiagnostics.getNodeSnapshots().add(selectedNodeSnapshot);
        for (Map.Entry<NodeIdentifier, SystemDiagnosticsDTO> entry : dtoMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            SystemDiagnosticsDTO toMerge = entry.getValue();
            if (toMerge == clientDto) continue;
            StatusMerger.merge(mergedSystemDiagnostics, toMerge, nodeId.getId(), nodeId.getApiAddress(), (Integer)nodeId.getApiPort());
        }
    }
}

