/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.StreamingOutput;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.HttpResponseMapper;
import org.apache.nifi.cluster.coordination.http.endpoints.AccessPolicyEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.BulletinBoardEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ComponentStateEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ConnectionEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ConnectionStatusEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ConnectionsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerBulletinsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerConfigurationEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerServiceEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerServiceReferenceEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerServiceTypesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerServicesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ControllerStatusEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.CountersEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.CurrentUserEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.DropAllFlowFilesRequestEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.DropRequestEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FlowConfigurationEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FlowMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FlowRegistryClientEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FlowRegistryClientsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FlowRepositoryClientTypesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FlowSnippetEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FunnelEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.FunnelsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.GroupStatusEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.InputPortsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.LabelEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.LabelsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ListFlowFilesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.OutputPortsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterContextEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterContextUpdateEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterContextValidationMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterContextsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterProviderEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterProviderFetchRequestsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterProvidersEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.PortEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.PortStatusEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.PrioritizerTypesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessGroupEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessGroupsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessorDiagnosticsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessorEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessorRunStatusDetailsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessorStatusEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessorTypesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProcessorsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProvenanceEventEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ProvenanceQueryEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.RemoteProcessGroupEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.RemoteProcessGroupStatusEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.RemoteProcessGroupsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ReplayLastEventEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ReportingTaskEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ReportingTaskTypesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.ReportingTasksEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.RuntimeManifestEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.SearchUsersEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.StatusHistoryEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.SystemDiagnosticsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.TemplatesEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.UserEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.UserGroupEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.UserGroupsEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.UsersEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.VariableRegistryEndpointMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.VerifyConfigEndpointMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.stream.io.NullOutputStream;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardHttpResponseMapper
implements HttpResponseMapper {
    private Logger logger = LoggerFactory.getLogger(StandardHttpResponseMapper.class);
    private final List<EndpointResponseMerger> endpointMergers = new ArrayList<EndpointResponseMerger>();

    public StandardHttpResponseMapper(NiFiProperties nifiProperties) {
        long snapshotMillis;
        String snapshotFrequency = nifiProperties.getProperty("nifi.components.status.snapshot.frequency", "5 mins");
        try {
            snapshotMillis = FormatUtils.getTimeDuration((String)snapshotFrequency, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            snapshotMillis = FormatUtils.getTimeDuration((String)"5 mins", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.endpointMergers.add(new ControllerStatusEndpointMerger());
        this.endpointMergers.add(new ControllerBulletinsEndpointMerger());
        this.endpointMergers.add(new GroupStatusEndpointMerger());
        this.endpointMergers.add(new ProcessorStatusEndpointMerger());
        this.endpointMergers.add(new ConnectionStatusEndpointMerger());
        this.endpointMergers.add(new PortStatusEndpointMerger());
        this.endpointMergers.add(new RemoteProcessGroupStatusEndpointMerger());
        this.endpointMergers.add(new ProcessorEndpointMerger());
        this.endpointMergers.add(new ProcessorsEndpointMerger());
        this.endpointMergers.add(new ProcessorRunStatusDetailsEndpointMerger());
        this.endpointMergers.add(new ConnectionEndpointMerger());
        this.endpointMergers.add(new ConnectionsEndpointMerger());
        this.endpointMergers.add(new PortEndpointMerger());
        this.endpointMergers.add(new InputPortsEndpointMerger());
        this.endpointMergers.add(new OutputPortsEndpointMerger());
        this.endpointMergers.add(new RemoteProcessGroupEndpointMerger());
        this.endpointMergers.add(new RemoteProcessGroupsEndpointMerger());
        this.endpointMergers.add(new ProcessGroupEndpointMerger());
        this.endpointMergers.add(new ProcessGroupsEndpointMerger());
        this.endpointMergers.add(new FlowSnippetEndpointMerger());
        this.endpointMergers.add(new ProvenanceQueryEndpointMerger());
        this.endpointMergers.add(new ProvenanceEventEndpointMerger());
        this.endpointMergers.add(new ControllerServiceEndpointMerger());
        this.endpointMergers.add(new ControllerServicesEndpointMerger());
        this.endpointMergers.add(new ControllerServiceReferenceEndpointMerger());
        this.endpointMergers.add(new ReportingTaskEndpointMerger());
        this.endpointMergers.add(new ReportingTasksEndpointMerger());
        this.endpointMergers.add(new DropRequestEndpointMerger());
        this.endpointMergers.add(new DropAllFlowFilesRequestEndpointMerger());
        this.endpointMergers.add(new ListFlowFilesEndpointMerger());
        this.endpointMergers.add(new ComponentStateEndpointMerger());
        this.endpointMergers.add(new BulletinBoardEndpointMerger());
        this.endpointMergers.add(new StatusHistoryEndpointMerger(snapshotMillis));
        this.endpointMergers.add(new SystemDiagnosticsEndpointMerger());
        this.endpointMergers.add(new CountersEndpointMerger());
        this.endpointMergers.add(new FlowMerger());
        this.endpointMergers.add(new ProcessorTypesEndpointMerger());
        this.endpointMergers.add(new ControllerServiceTypesEndpointMerger());
        this.endpointMergers.add(new ReportingTaskTypesEndpointMerger());
        this.endpointMergers.add(new PrioritizerTypesEndpointMerger());
        this.endpointMergers.add(new ControllerConfigurationEndpointMerger());
        this.endpointMergers.add(new CurrentUserEndpointMerger());
        this.endpointMergers.add(new FlowConfigurationEndpointMerger());
        this.endpointMergers.add(new TemplatesEndpointMerger());
        this.endpointMergers.add(new LabelEndpointMerger());
        this.endpointMergers.add(new LabelsEndpointMerger());
        this.endpointMergers.add(new FunnelEndpointMerger());
        this.endpointMergers.add(new FunnelsEndpointMerger());
        this.endpointMergers.add(new ControllerEndpointMerger());
        this.endpointMergers.add(new UsersEndpointMerger());
        this.endpointMergers.add(new UserEndpointMerger());
        this.endpointMergers.add(new UserGroupsEndpointMerger());
        this.endpointMergers.add(new UserGroupEndpointMerger());
        this.endpointMergers.add(new AccessPolicyEndpointMerger());
        this.endpointMergers.add(new SearchUsersEndpointMerger());
        this.endpointMergers.add(new VariableRegistryEndpointMerger());
        this.endpointMergers.add(new ProcessorDiagnosticsEndpointMerger(snapshotMillis));
        this.endpointMergers.add(new ParameterContextValidationMerger());
        this.endpointMergers.add(new ParameterContextsEndpointMerger());
        this.endpointMergers.add(new ParameterContextEndpointMerger());
        this.endpointMergers.add(new ParameterContextUpdateEndpointMerger());
        this.endpointMergers.add(new VerifyConfigEndpointMerger());
        this.endpointMergers.add(new RuntimeManifestEndpointMerger());
        this.endpointMergers.add(new ReplayLastEventEndpointMerger());
        this.endpointMergers.add(new ParameterProviderEndpointMerger());
        this.endpointMergers.add(new ParameterProvidersEndpointMerger());
        this.endpointMergers.add(new ParameterProviderFetchRequestsEndpointMerger());
        this.endpointMergers.add(new FlowRegistryClientEndpointMerger());
        this.endpointMergers.add(new FlowRegistryClientsEndpointMerger());
        this.endpointMergers.add(new FlowRepositoryClientTypesEndpointMerger());
    }

    @Override
    public NodeResponse mapResponses(URI uri, String httpMethod, Set<NodeResponse> nodeResponses, boolean merge) {
        boolean hasSuccess = this.hasSuccessfulResponse(nodeResponses);
        if (!hasSuccess) {
            NodeResponse clientResponse = nodeResponses.stream().filter(p -> p.getStatus() > 299).findAny().orElse(nodeResponses.iterator().next());
            this.drainResponses(nodeResponses, clientResponse);
            return clientResponse;
        }
        Set<NodeResponse> successResponses = nodeResponses.stream().filter(NodeResponse::is2xx).collect(Collectors.toSet());
        Set<NodeResponse> problematicResponses = nodeResponses.stream().filter(p -> !p.is2xx()).collect(Collectors.toSet());
        if ("GET".equalsIgnoreCase(httpMethod) && problematicResponses.size() > 0) {
            NodeResponse clientResponse = problematicResponses.stream().filter(p -> p.getStatus() >= 400 && p.getStatus() < 500).findFirst().orElse(problematicResponses.stream().filter(p -> p.getStatus() > 500).findFirst().orElse((NodeResponse)problematicResponses.iterator().next()));
            return clientResponse;
        }
        NodeResponse clientResponse = (NodeResponse)successResponses.iterator().next();
        if (!merge) {
            return clientResponse;
        }
        EndpointResponseMerger merger = this.getEndpointResponseMerger(uri, httpMethod);
        if (merger == null) {
            return clientResponse;
        }
        NodeResponse response = merger.merge(uri, httpMethod, successResponses, problematicResponses, clientResponse);
        return response;
    }

    @Override
    public Set<NodeResponse> getProblematicNodeResponses(Set<NodeResponse> allResponses) {
        boolean containsSuccessfulResponse = this.hasSuccessfulResponse(allResponses);
        if (containsSuccessfulResponse) {
            return allResponses.stream().filter(p -> !p.is2xx()).collect(Collectors.toSet());
        }
        return allResponses.stream().filter(NodeResponse::is5xx).collect(Collectors.toSet());
    }

    @Override
    public boolean isResponseInterpreted(URI uri, String httpMethod) {
        return this.getEndpointResponseMerger(uri, httpMethod) != null;
    }

    private EndpointResponseMerger getEndpointResponseMerger(URI uri, String httpMethod) {
        return this.endpointMergers.stream().filter(p -> p.canHandle(uri, httpMethod)).findFirst().orElse(null);
    }

    private boolean hasSuccessfulResponse(Set<NodeResponse> allResponses) {
        return allResponses.stream().anyMatch(NodeResponse::is2xx);
    }

    private void drainResponses(Set<NodeResponse> responses, NodeResponse exclude) {
        ((Stream)responses.stream().parallel()).filter(response -> response != exclude).filter(response -> response.getStatus() != 202).forEach(this::drainResponse);
    }

    private void drainResponse(NodeResponse response) {
        if (response.hasThrowable()) {
            return;
        }
        try {
            ((StreamingOutput)response.getResponse().getEntity()).write((OutputStream)new NullOutputStream());
        }
        catch (IOException ioe) {
            this.logger.info("Failed clearing out non-client response buffer from " + response.getNodeId() + " due to: " + ioe, (Throwable)ioe);
        }
    }
}

