/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.spring;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import javax.net.ssl.SSLContext;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestCompletionCallback;
import org.apache.nifi.cluster.coordination.http.replication.ThreadPoolRequestReplicator;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.util.WebUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ThreadPoolRequestReplicatorFactoryBean
implements FactoryBean<ThreadPoolRequestReplicator>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private NiFiProperties nifiProperties;
    private ThreadPoolRequestReplicator replicator = null;

    public ThreadPoolRequestReplicator getObject() throws Exception {
        if (this.replicator == null && this.nifiProperties.isNode()) {
            EventReporter eventReporter = (EventReporter)this.applicationContext.getBean("eventReporter", EventReporter.class);
            ClusterCoordinator clusterCoordinator = (ClusterCoordinator)this.applicationContext.getBean("clusterCoordinator", ClusterCoordinator.class);
            RequestCompletionCallback requestCompletionCallback = (RequestCompletionCallback)this.applicationContext.getBean("clusterCoordinator", RequestCompletionCallback.class);
            int corePoolSize = this.nifiProperties.getClusterNodeProtocolCorePoolSize();
            int maxPoolSize = this.nifiProperties.getClusterNodeProtocolMaxPoolSize();
            Client jerseyClient = WebUtils.createClient((ClientConfig)new DefaultClientConfig(), (SSLContext)SslContextFactory.createSslContext((NiFiProperties)this.nifiProperties));
            String connectionTimeout = this.nifiProperties.getClusterNodeConnectionTimeout();
            String readTimeout = this.nifiProperties.getClusterNodeReadTimeout();
            this.replicator = new ThreadPoolRequestReplicator(corePoolSize, maxPoolSize, jerseyClient, clusterCoordinator, connectionTimeout, readTimeout, requestCompletionCallback, eventReporter, this.nifiProperties);
        }
        return this.replicator;
    }

    public Class<?> getObjectType() {
        return ThreadPoolRequestReplicator.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.nifiProperties = properties;
    }
}

