/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.status.history.ConnectionStatusDescriptor;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.ProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessorStatusDescriptor;
import org.apache.nifi.controller.status.history.RemoteProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusHistoryUtil;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.ValueMapper;
import org.apache.nifi.web.api.dto.status.NodeStatusSnapshotsDTO;
import org.apache.nifi.web.api.dto.status.StatusDescriptorDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.dto.status.StatusSnapshotDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.StatusHistoryEntity;

public class StatusHistoryEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern PROCESSOR_STATUS_HISTORY_URI_PATTERN = Pattern.compile("/nifi-api/flow/processors/[a-f0-9\\-]{36}/status/history");
    public static final Pattern PROCESS_GROUP_STATUS_HISTORY_URI_PATTERN = Pattern.compile("/nifi-api/flow/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/status/history");
    public static final Pattern REMOTE_PROCESS_GROUP_STATUS_HISTORY_URI_PATTERN = Pattern.compile("/nifi-api/flow/remote-process-groups/[a-f0-9\\-]{36}/status/history");
    public static final Pattern CONNECTION_STATUS_HISTORY_URI_PATTERN = Pattern.compile("/nifi-api/flow/connections/[a-f0-9\\-]{36}/status/history");
    private final long componentStatusSnapshotMillis;

    public StatusHistoryEndpointMerger(long componentStatusSnapshotMillis) {
        this.componentStatusSnapshotMillis = componentStatusSnapshotMillis;
    }

    private Map<String, MetricDescriptor<?>> getStandardMetricDescriptors(URI uri) {
        HashMap metricDescriptors;
        block5: {
            String path;
            block7: {
                block6: {
                    block4: {
                        path = uri.getPath();
                        metricDescriptors = new HashMap();
                        if (!PROCESSOR_STATUS_HISTORY_URI_PATTERN.matcher(path).matches()) break block4;
                        for (ProcessorStatusDescriptor descriptor : ProcessorStatusDescriptor.values()) {
                            metricDescriptors.put(descriptor.getField(), descriptor.getDescriptor());
                        }
                        break block5;
                    }
                    if (!PROCESS_GROUP_STATUS_HISTORY_URI_PATTERN.matcher(path).matches()) break block6;
                    for (ProcessGroupStatusDescriptor descriptor : ProcessGroupStatusDescriptor.values()) {
                        metricDescriptors.put(descriptor.getField(), descriptor.getDescriptor());
                    }
                    break block5;
                }
                if (!REMOTE_PROCESS_GROUP_STATUS_HISTORY_URI_PATTERN.matcher(path).matches()) break block7;
                for (RemoteProcessGroupStatusDescriptor descriptor : RemoteProcessGroupStatusDescriptor.values()) {
                    metricDescriptors.put(descriptor.getField(), descriptor.getDescriptor());
                }
                break block5;
            }
            if (!CONNECTION_STATUS_HISTORY_URI_PATTERN.matcher(path).matches()) break block5;
            for (ConnectionStatusDescriptor descriptor : ConnectionStatusDescriptor.values()) {
                metricDescriptors.put(descriptor.getField(), descriptor.getDescriptor());
            }
        }
        return metricDescriptors;
    }

    @Override
    public boolean canHandle(URI uri, String method) {
        if (!"GET".equalsIgnoreCase(method)) {
            return false;
        }
        Map<String, MetricDescriptor<?>> descriptors = this.getStandardMetricDescriptors(uri);
        return descriptors != null && !descriptors.isEmpty();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        Map<String, MetricDescriptor<?>> metricDescriptors = this.getStandardMetricDescriptors(uri);
        StatusHistoryEntity responseEntity = (StatusHistoryEntity)clientResponse.getClientResponse().getEntity(StatusHistoryEntity.class);
        LinkedHashSet fieldDescriptors = new LinkedHashSet();
        boolean includeCounters = true;
        StatusHistoryDTO lastStatusHistory = null;
        ArrayList<NodeStatusSnapshotsDTO> nodeStatusSnapshots = new ArrayList<NodeStatusSnapshotsDTO>(successfulResponses.size());
        LinkedHashMap noReadPermissionsComponentDetails = null;
        for (NodeResponse nodeResponse : successfulResponses) {
            StatusHistoryDTO nodeStatus;
            StatusHistoryEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (StatusHistoryEntity)nodeResponse.getClientResponse().getEntity(StatusHistoryEntity.class);
            lastStatusHistory = nodeStatus = nodeResponseEntity.getStatusHistory();
            if (noReadPermissionsComponentDetails == null && !nodeResponseEntity.getCanRead().booleanValue()) {
                noReadPermissionsComponentDetails = nodeStatus.getComponentDetails();
            }
            if (!Boolean.TRUE.equals(nodeResponseEntity.getCanRead())) {
                includeCounters = false;
            }
            NodeIdentifier nodeId = nodeResponse.getNodeId();
            NodeStatusSnapshotsDTO nodeStatusSnapshot = new NodeStatusSnapshotsDTO();
            nodeStatusSnapshot.setNodeId(nodeId.getId());
            nodeStatusSnapshot.setAddress(nodeId.getApiAddress());
            nodeStatusSnapshot.setApiPort(Integer.valueOf(nodeId.getApiPort()));
            nodeStatusSnapshot.setStatusSnapshots(nodeStatus.getAggregateSnapshots());
            nodeStatusSnapshots.add(nodeStatusSnapshot);
            List descriptors = nodeStatus.getFieldDescriptors();
            if (descriptors == null) continue;
            fieldDescriptors.addAll(descriptors);
        }
        if (includeCounters) {
            for (StatusDescriptorDTO descriptorDto : fieldDescriptors) {
                String fieldName = descriptorDto.getField();
                if (metricDescriptors.containsKey(fieldName)) continue;
                ValueMapper valueMapper = s -> {
                    Map counters = s.getCounters();
                    if (counters == null) {
                        return 0L;
                    }
                    return counters.getOrDefault(descriptorDto.getField(), 0L);
                };
                StandardMetricDescriptor metricDescriptor = new StandardMetricDescriptor(descriptorDto.getField(), descriptorDto.getLabel(), descriptorDto.getDescription(), MetricDescriptor.Formatter.COUNT, valueMapper);
                metricDescriptors.put(fieldName, (MetricDescriptor<?>)metricDescriptor);
            }
        }
        StatusHistoryDTO clusterStatusHistory = new StatusHistoryDTO();
        clusterStatusHistory.setAggregateSnapshots(this.mergeStatusHistories(nodeStatusSnapshots, metricDescriptors));
        clusterStatusHistory.setGenerated(new Date());
        clusterStatusHistory.setNodeSnapshots(nodeStatusSnapshots);
        if (lastStatusHistory != null) {
            clusterStatusHistory.setComponentDetails(noReadPermissionsComponentDetails == null ? lastStatusHistory.getComponentDetails() : noReadPermissionsComponentDetails);
        }
        clusterStatusHistory.setFieldDescriptors(new ArrayList(fieldDescriptors));
        StatusHistoryEntity clusterEntity = new StatusHistoryEntity();
        clusterEntity.setStatusHistory(clusterStatusHistory);
        clusterEntity.setCanRead(Boolean.valueOf(noReadPermissionsComponentDetails == null));
        return new NodeResponse(clientResponse, (Entity)clusterEntity);
    }

    private List<StatusSnapshotDTO> mergeStatusHistories(List<NodeStatusSnapshotsDTO> nodeStatusSnapshots, Map<String, MetricDescriptor<?>> metricDescriptors) {
        TreeMap<Date, HashMap<String, StatusSnapshot>> dateToNodeSnapshots = new TreeMap<Date, HashMap<String, StatusSnapshot>>();
        for (NodeStatusSnapshotsDTO nodeStatusSnapshotsDTO : nodeStatusSnapshots) {
            for (StatusSnapshotDTO snapshotDto : nodeStatusSnapshotsDTO.getStatusSnapshots()) {
                StatusSnapshot snapshot = this.createSnapshot(snapshotDto, metricDescriptors);
                Date normalizedDate = StatusHistoryEndpointMerger.normalizeStatusSnapshotDate(snapshot.getTimestamp(), this.componentStatusSnapshotMillis);
                HashMap<String, StatusSnapshot> nodeToSnapshotMap = (HashMap<String, StatusSnapshot>)dateToNodeSnapshots.get(normalizedDate);
                if (nodeToSnapshotMap == null) {
                    nodeToSnapshotMap = new HashMap<String, StatusSnapshot>();
                    dateToNodeSnapshots.put(normalizedDate, nodeToSnapshotMap);
                }
                nodeToSnapshotMap.put(nodeStatusSnapshotsDTO.getNodeId(), snapshot);
            }
        }
        TreeMap<Date, List<StatusSnapshot>> snapshotsToAggregate = new TreeMap<Date, List<StatusSnapshot>>();
        for (Map.Entry entry : dateToNodeSnapshots.entrySet()) {
            Date normalizedDate = (Date)entry.getKey();
            Map nodeToSnapshot = (Map)entry.getValue();
            ArrayList snapshotsForTimestamp = new ArrayList(nodeToSnapshot.values());
            snapshotsToAggregate.put(normalizedDate, snapshotsForTimestamp);
        }
        List<StatusSnapshotDTO> list = this.aggregate(snapshotsToAggregate);
        return list;
    }

    private StatusSnapshot createSnapshot(StatusSnapshotDTO snapshotDto, Map<String, MetricDescriptor<?>> metricDescriptors) {
        StandardStatusSnapshot snapshot = new StandardStatusSnapshot();
        snapshot.setTimestamp(snapshotDto.getTimestamp());
        for (MetricDescriptor<?> descriptor : metricDescriptors.values()) {
            String field;
            snapshot.addStatusMetric(descriptor, Long.valueOf(0L));
            Map dtoMetrics = snapshotDto.getStatusMetrics();
            if (dtoMetrics.containsKey(field = descriptor.getField())) continue;
            dtoMetrics.put(field, 0L);
        }
        Map metrics = snapshotDto.getStatusMetrics();
        for (Map.Entry entry : metrics.entrySet()) {
            String metricId = (String)entry.getKey();
            Long value = (Long)entry.getValue();
            MetricDescriptor<?> descriptor = metricDescriptors.get(metricId);
            if (descriptor == null) continue;
            snapshot.addStatusMetric(descriptor, value);
        }
        return snapshot;
    }

    private List<StatusSnapshotDTO> aggregate(Map<Date, List<StatusSnapshot>> snapshotsToAggregate) {
        ArrayList<StatusSnapshotDTO> aggregatedSnapshotDtos = new ArrayList<StatusSnapshotDTO>();
        for (Map.Entry<Date, List<StatusSnapshot>> entry : snapshotsToAggregate.entrySet()) {
            List<StatusSnapshot> snapshots = entry.getValue();
            StatusSnapshot reducedSnapshot = (StatusSnapshot)snapshots.get(0).getValueReducer().reduce(snapshots);
            StatusSnapshotDTO dto = new StatusSnapshotDTO();
            dto.setTimestamp(reducedSnapshot.getTimestamp());
            dto.setStatusMetrics(StatusHistoryUtil.createStatusSnapshotDto((StatusSnapshot)reducedSnapshot).getStatusMetrics());
            aggregatedSnapshotDtos.add(dto);
        }
        return aggregatedSnapshotDtos;
    }

    public static Date normalizeStatusSnapshotDate(Date toNormalize, long numMillis) {
        long time = toNormalize.getTime();
        return new Date(time - time % numMillis);
    }
}

