/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.flow;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.flow.FlowElection;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.StandardFlowSynchronizer;
import org.apache.nifi.fingerprint.FingerprintFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopularVoteFlowElection
implements FlowElection {
    private static final Logger logger = LoggerFactory.getLogger(PopularVoteFlowElection.class);
    private final long maxWaitNanos;
    private final Integer maxNodes;
    private final FingerprintFactory fingerprintFactory;
    private volatile Long startNanos = null;
    private volatile DataFlow electedDataFlow = null;
    private final Map<String, FlowCandidate> candidateByFingerprint = new HashMap<String, FlowCandidate>();

    public PopularVoteFlowElection(long maxWait, TimeUnit maxWaitPeriod, Integer maxNodes, FingerprintFactory fingerprintFactory) {
        this.maxWaitNanos = maxWaitPeriod.toNanos(maxWait);
        if (this.maxWaitNanos < 1L) {
            throw new IllegalArgumentException("Maximum wait time to elect Cluster Flow cannot be less than 1 nanosecond");
        }
        this.maxNodes = maxNodes;
        if (maxNodes != null && maxNodes < 1) {
            throw new IllegalArgumentException("Maximum number of nodes to wait on before electing Cluster Flow cannot be less than 1");
        }
        this.fingerprintFactory = Objects.requireNonNull(fingerprintFactory);
    }

    @Override
    public synchronized boolean isElectionComplete() {
        int numVotes;
        if (this.electedDataFlow != null) {
            return true;
        }
        if (this.startNanos == null) {
            return false;
        }
        long nanosSinceStart = System.nanoTime() - this.startNanos;
        if (nanosSinceStart > this.maxWaitNanos) {
            FlowCandidate elected = this.performElection();
            logger.info("Election is complete because the maximum allowed time has elapsed. The elected dataflow is held by the following nodes: {}", elected.getNodes());
            return true;
        }
        if (this.maxNodes != null && (numVotes = this.getVoteCount()) >= this.maxNodes) {
            FlowCandidate elected = this.performElection();
            logger.info("Election is complete because the required number of nodes ({}) have voted. The elected dataflow is held by the following nodes: {}", (Object)this.maxNodes, elected.getNodes());
            return true;
        }
        return false;
    }

    @Override
    public boolean isVoteCounted(NodeIdentifier nodeIdentifier) {
        return this.candidateByFingerprint.values().stream().anyMatch(candidate -> candidate.getNodes().contains(nodeIdentifier));
    }

    private synchronized int getVoteCount() {
        return this.candidateByFingerprint.values().stream().mapToInt(candidate -> candidate.getVotes()).sum();
    }

    @Override
    public synchronized DataFlow castVote(DataFlow candidate, NodeIdentifier nodeId) {
        if (candidate == null || this.isElectionComplete()) {
            return this.getElectedDataFlow();
        }
        String fingerprint = this.fingerprint(candidate);
        FlowCandidate flowCandidate = this.candidateByFingerprint.computeIfAbsent(fingerprint, key -> new FlowCandidate(candidate));
        boolean voteCast = flowCandidate.vote(nodeId);
        if (this.startNanos == null) {
            this.startNanos = System.nanoTime();
        }
        if (voteCast) {
            logger.info("Vote cast by {}; this flow now has {} votes", (Object)nodeId, (Object)flowCandidate.getVotes());
        }
        if (this.isElectionComplete()) {
            return this.getElectedDataFlow();
        }
        return null;
    }

    private String fingerprint(DataFlow dataFlow) {
        String flowFingerprint = this.fingerprintFactory.createFingerprint(dataFlow.getFlow());
        String authFingerprint = dataFlow.getAuthorizerFingerprint() == null ? "" : new String(dataFlow.getAuthorizerFingerprint(), StandardCharsets.UTF_8);
        String candidateFingerprint = flowFingerprint + authFingerprint;
        return candidateFingerprint;
    }

    @Override
    public DataFlow getElectedDataFlow() {
        return this.electedDataFlow;
    }

    private FlowCandidate performElection() {
        if (this.candidateByFingerprint.isEmpty()) {
            return null;
        }
        List nonEmptyCandidates = this.candidateByFingerprint.values().stream().filter(candidate -> !candidate.isFlowEmpty()).collect(Collectors.toList());
        if (nonEmptyCandidates.isEmpty()) {
            FlowCandidate electedCandidate = this.candidateByFingerprint.values().iterator().next();
            this.electedDataFlow = electedCandidate.getDataFlow();
            return electedCandidate;
        }
        FlowCandidate elected = nonEmptyCandidates.size() == 1 ? (FlowCandidate)nonEmptyCandidates.iterator().next() : (FlowCandidate)nonEmptyCandidates.stream().max((candidate1, candidate2) -> Integer.compare(candidate1.getVotes(), candidate2.getVotes())).get();
        this.electedDataFlow = elected.getDataFlow();
        return elected;
    }

    @Override
    public synchronized String getStatusDescription() {
        if (this.startNanos == null) {
            return "No votes have yet been cast.";
        }
        StringBuilder descriptionBuilder = new StringBuilder("Election will complete in ");
        long nanosElapsed = System.nanoTime() - this.startNanos;
        long nanosLeft = this.maxWaitNanos - nanosElapsed;
        long secsLeft = TimeUnit.NANOSECONDS.toSeconds(nanosLeft);
        if (secsLeft < 1L) {
            descriptionBuilder.append("less than 1 second");
        } else {
            descriptionBuilder.append(secsLeft).append(" seconds");
        }
        if (this.maxNodes != null) {
            int votesNeeded = this.maxNodes - this.getVoteCount();
            descriptionBuilder.append(" or after ").append(votesNeeded).append(" more vote");
            descriptionBuilder.append(votesNeeded == 1 ? " is " : "s are ");
            descriptionBuilder.append("cast, whichever occurs first.");
        }
        return descriptionBuilder.toString();
    }

    private static class FlowCandidate {
        private final DataFlow dataFlow;
        private final AtomicInteger voteCount = new AtomicInteger(0);
        private final Set<NodeIdentifier> nodeIds = Collections.synchronizedSet(new HashSet());

        public FlowCandidate(DataFlow dataFlow) {
            this.dataFlow = dataFlow;
        }

        public boolean vote(NodeIdentifier nodeId) {
            if (this.nodeIds.add(nodeId)) {
                this.voteCount.incrementAndGet();
                return true;
            }
            return false;
        }

        public int getVotes() {
            return this.voteCount.get();
        }

        public DataFlow getDataFlow() {
            return this.dataFlow;
        }

        public boolean isFlowEmpty() {
            return StandardFlowSynchronizer.isEmpty((DataFlow)this.dataFlow);
        }

        public Set<NodeIdentifier> getNodes() {
            return this.nodeIds;
        }
    }
}

