/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.entity.CurrentUserEntity;

public class CurrentUserEndpointMerger
extends AbstractSingleEntityEndpoint<CurrentUserEntity> {
    public static final Pattern CURRENT_USER_URI_PATTERN = Pattern.compile("/nifi-api/flow/current-user");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && CURRENT_USER_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<CurrentUserEntity> getEntityClass() {
        return CurrentUserEntity.class;
    }

    @Override
    protected void mergeResponses(CurrentUserEntity clientEntity, Map<NodeIdentifier, CurrentUserEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        for (Map.Entry<NodeIdentifier, CurrentUserEntity> entry : entityMap.entrySet()) {
            CurrentUserEntity entity = entry.getValue();
            if (entity == clientEntity) continue;
            this.mergePermissions(clientEntity.getControllerPermissions(), entity.getControllerPermissions());
            this.mergePermissions(clientEntity.getCountersPermissions(), entity.getCountersPermissions());
            this.mergePermissions(clientEntity.getPoliciesPermissions(), entity.getPoliciesPermissions());
            this.mergePermissions(clientEntity.getProvenancePermissions(), entity.getProvenancePermissions());
            this.mergePermissions(clientEntity.getTenantsPermissions(), entity.getTenantsPermissions());
        }
    }

    private void mergePermissions(PermissionsDTO clientPermissions, PermissionsDTO permissions) {
        clientPermissions.setCanRead(Boolean.valueOf(clientPermissions.getCanRead() != false && permissions.getCanRead() != false));
        clientPermissions.setCanWrite(Boolean.valueOf(clientPermissions.getCanWrite() != false && permissions.getCanWrite() != false));
    }
}

