/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;

public class RemoteProcessGroupEntityMerger
implements ComponentEntityMerger<RemoteProcessGroupEntity>,
ComponentEntityStatusMerger<RemoteProcessGroupStatusDTO> {
    @Override
    public void merge(RemoteProcessGroupEntity clientEntity, Map<NodeIdentifier, RemoteProcessGroupEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
        for (Map.Entry<NodeIdentifier, RemoteProcessGroupEntity> entry : entityMap.entrySet()) {
            RemoteProcessGroupEntity entityStatus = entry.getValue();
            if (entityStatus == clientEntity) continue;
            this.mergeStatus(clientEntity.getStatus(), (boolean)clientEntity.getPermissions().getCanRead(), entry.getValue().getStatus(), (boolean)entry.getValue().getPermissions().getCanRead(), entry.getKey());
        }
    }

    @Override
    public void mergeComponents(RemoteProcessGroupEntity clientEntity, Map<NodeIdentifier, RemoteProcessGroupEntity> entityMap) {
        RemoteProcessGroupDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, RemoteProcessGroupDTO> dtoMap = new HashMap<NodeIdentifier, RemoteProcessGroupDTO>();
        for (Map.Entry<NodeIdentifier, RemoteProcessGroupEntity> entry : entityMap.entrySet()) {
            RemoteProcessGroupEntity nodeProcEntity = entry.getValue();
            RemoteProcessGroupDTO nodeProcDto = nodeProcEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeProcDto);
        }
        RemoteProcessGroupEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    @Override
    public void mergeStatus(RemoteProcessGroupStatusDTO clientStatus, boolean clientStatusReadablePermission, RemoteProcessGroupStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }

    private static void mergeDtos(RemoteProcessGroupDTO clientDto, Map<NodeIdentifier, RemoteProcessGroupDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        RemoteProcessGroupContentsDTO remoteProcessGroupContents = clientDto.getContents();
        HashMap<String, Set<NodeIdentifier>> authorizationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        Boolean mergedIsTargetSecure = null;
        HashSet mergedInputPorts = new HashSet();
        HashSet mergedOutputPorts = new HashSet();
        for (Map.Entry<NodeIdentifier, RemoteProcessGroupDTO> nodeEntry : dtoMap.entrySet()) {
            RemoteProcessGroupDTO nodeRemoteProcessGroup = nodeEntry.getValue();
            if (nodeRemoteProcessGroup == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            ErrorMerger.mergeErrors(authorizationErrorMap, nodeId, nodeRemoteProcessGroup.getAuthorizationIssues());
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodeRemoteProcessGroup.getValidationErrors());
            Boolean nodeIsTargetSecure = nodeRemoteProcessGroup.isTargetSecure();
            if (mergedIsTargetSecure == null) {
                mergedIsTargetSecure = nodeIsTargetSecure;
            }
            RemoteProcessGroupContentsDTO nodeRemoteProcessGroupContentsDto = nodeRemoteProcessGroup.getContents();
            if (remoteProcessGroupContents == null || nodeRemoteProcessGroupContentsDto == null) continue;
            if (nodeRemoteProcessGroupContentsDto.getInputPorts() != null) {
                mergedInputPorts.addAll(nodeRemoteProcessGroupContentsDto.getInputPorts());
            }
            if (nodeRemoteProcessGroupContentsDto.getOutputPorts() == null) continue;
            mergedOutputPorts.addAll(nodeRemoteProcessGroupContentsDto.getOutputPorts());
        }
        if (remoteProcessGroupContents != null) {
            if (!mergedInputPorts.isEmpty()) {
                remoteProcessGroupContents.setInputPorts(mergedInputPorts);
            }
            if (!mergedOutputPorts.isEmpty()) {
                remoteProcessGroupContents.setOutputPorts(mergedOutputPorts);
            }
        }
        if (mergedIsTargetSecure != null) {
            clientDto.setTargetSecure(mergedIsTargetSecure);
        }
        clientDto.setAuthorizationIssues(ErrorMerger.normalizedMergedErrors(authorizationErrorMap, dtoMap.size()));
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }
}

