/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.manager.PropertyDescriptorDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ControllerServiceReferencingComponentDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentEntity;

public class ControllerServiceEntityMerger
implements ComponentEntityMerger<ControllerServiceEntity> {
    @Override
    public void mergeComponents(ControllerServiceEntity clientEntity, Map<NodeIdentifier, ControllerServiceEntity> entityMap) {
        ControllerServiceDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, ControllerServiceDTO> dtoMap = new HashMap<NodeIdentifier, ControllerServiceDTO>();
        for (Map.Entry<NodeIdentifier, ControllerServiceEntity> entry : entityMap.entrySet()) {
            ControllerServiceEntity nodeControllerServiceEntity = entry.getValue();
            ControllerServiceDTO nodeControllerServiceDto = nodeControllerServiceEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeControllerServiceDto);
        }
        ControllerServiceEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    private static void mergeDtos(ControllerServiceDTO clientDto, Map<NodeIdentifier, ControllerServiceDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        Set referencingComponents = clientDto.getReferencingComponents();
        HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>> nodeReferencingComponentsMap = new HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>>();
        HashMap propertyDescriptorMap = new HashMap();
        String state = null;
        for (Map.Entry<NodeIdentifier, ControllerServiceDTO> nodeEntry : dtoMap.entrySet()) {
            ControllerServiceDTO nodeControllerService = nodeEntry.getValue();
            if (nodeControllerService == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            if (state == null) {
                if (ControllerServiceState.DISABLING.name().equals(nodeControllerService.getState())) {
                    state = ControllerServiceState.DISABLING.name();
                } else if (ControllerServiceState.ENABLING.name().equals(nodeControllerService.getState())) {
                    state = ControllerServiceState.ENABLING.name();
                }
            }
            nodeReferencingComponentsMap.put(nodeId, nodeControllerService.getReferencingComponents());
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodeControllerService.getValidationErrors());
            Map descriptors = nodeControllerService.getDescriptors();
            if (descriptors == null) continue;
            descriptors.values().stream().forEach(propertyDescriptor -> propertyDescriptorMap.computeIfAbsent(propertyDescriptor.getName(), nodeIdToPropertyDescriptor -> new HashMap()).put(nodeId, propertyDescriptor));
        }
        for (Map propertyDescriptorByNodeId : propertyDescriptorMap.values()) {
            Collection nodePropertyDescriptors = propertyDescriptorByNodeId.values();
            if (nodePropertyDescriptors.isEmpty()) continue;
            PropertyDescriptorDTO propertyDescriptor2 = (PropertyDescriptorDTO)nodePropertyDescriptors.iterator().next();
            PropertyDescriptorDTO clientPropertyDescriptor = (PropertyDescriptorDTO)clientDto.getDescriptors().get(propertyDescriptor2.getName());
            PropertyDescriptorDtoMerger.merge(clientPropertyDescriptor, propertyDescriptorByNodeId);
        }
        ControllerServiceEntityMerger.mergeControllerServiceReferences(referencingComponents, nodeReferencingComponentsMap);
        if (state != null) {
            clientDto.setState(state);
        }
        Set<String> statuses = dtoMap.values().stream().map(ControllerServiceDTO::getValidationStatus).collect(Collectors.toSet());
        clientDto.setValidationStatus(ErrorMerger.mergeValidationStatus(statuses));
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }

    public static void mergeControllerServiceReferences(Set<ControllerServiceReferencingComponentEntity> referencingComponents, Map<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>> referencingComponentMap) {
        HashMap<String, Integer> activeThreadCounts = new HashMap<String, Integer>();
        HashMap<String, String> states = new HashMap<String, String>();
        HashMap<String, PermissionsDTO> canReads = new HashMap<String, PermissionsDTO>();
        for (Map.Entry<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>> nodeEntry : referencingComponentMap.entrySet()) {
            Set<ControllerServiceReferencingComponentEntity> nodeReferencingComponents = nodeEntry.getValue();
            if (nodeReferencingComponents == null) continue;
            for (ControllerServiceReferencingComponentEntity nodeReferencingComponentEntity : nodeReferencingComponents) {
                ControllerServiceReferencingComponentDTO nodeReferencingComponent = nodeReferencingComponentEntity.getComponent();
                if (nodeReferencingComponentEntity.getPermissions().getCanRead().booleanValue()) {
                    String state;
                    if (nodeReferencingComponent.getActiveThreadCount() != null && nodeReferencingComponent.getActiveThreadCount() > 0) {
                        Integer current = (Integer)activeThreadCounts.get(nodeReferencingComponent.getId());
                        if (current == null) {
                            activeThreadCounts.put(nodeReferencingComponent.getId(), nodeReferencingComponent.getActiveThreadCount());
                        } else {
                            activeThreadCounts.put(nodeReferencingComponent.getId(), nodeReferencingComponent.getActiveThreadCount() + current);
                        }
                    }
                    if ((state = (String)states.get(nodeReferencingComponent.getId())) == null) {
                        if (ControllerServiceState.DISABLING.name().equals(nodeReferencingComponent.getState())) {
                            states.put(nodeReferencingComponent.getId(), ControllerServiceState.DISABLING.name());
                        } else if (ControllerServiceState.ENABLING.name().equals(nodeReferencingComponent.getState())) {
                            states.put(nodeReferencingComponent.getId(), ControllerServiceState.ENABLING.name());
                        }
                    }
                }
                PermissionsDTO mergedPermissions = (PermissionsDTO)canReads.get(nodeReferencingComponentEntity.getId());
                PermissionsDTO permissions = nodeReferencingComponentEntity.getPermissions();
                if (permissions == null) continue;
                if (mergedPermissions == null) {
                    canReads.put(nodeReferencingComponentEntity.getId(), permissions);
                    continue;
                }
                PermissionsDtoMerger.mergePermissions(mergedPermissions, permissions);
            }
        }
        if (referencingComponents != null) {
            for (ControllerServiceReferencingComponentEntity referencingComponent : referencingComponents) {
                PermissionsDTO permissions = (PermissionsDTO)canReads.get(referencingComponent.getId());
                if (permissions != null && permissions.getCanRead() != null && permissions.getCanRead().booleanValue()) {
                    String state;
                    Integer activeThreadCount = (Integer)activeThreadCounts.get(referencingComponent.getId());
                    if (activeThreadCount != null) {
                        referencingComponent.getComponent().setActiveThreadCount(activeThreadCount);
                    }
                    if ((state = (String)states.get(referencingComponent.getId())) != null) {
                        referencingComponent.getComponent().setState(state);
                    }
                    HashMap<NodeIdentifier, ControllerServiceReferencingComponentEntity> nodeEntities = new HashMap<NodeIdentifier, ControllerServiceReferencingComponentEntity>();
                    referencingComponentMap.entrySet().forEach(entry -> {
                        NodeIdentifier nodeIdentifier = (NodeIdentifier)entry.getKey();
                        Set nodeControllerServiceReferencingComponents = (Set)entry.getValue();
                        nodeControllerServiceReferencingComponents.forEach(nodeControllerServiceReferencingComponent -> {
                            if (referencingComponent.getId() != null && referencingComponent.getId().equals(nodeControllerServiceReferencingComponent.getId())) {
                                nodeEntities.put(nodeIdentifier, (ControllerServiceReferencingComponentEntity)nodeControllerServiceReferencingComponent);
                            }
                        });
                    });
                    ControllerServiceEntityMerger.mergeControllerServiceReferencingComponent(referencingComponent, nodeEntities);
                    continue;
                }
                referencingComponent.setPermissions(permissions);
                referencingComponent.setComponent(null);
            }
        }
    }

    private static void mergeControllerServiceReferencingComponent(ControllerServiceReferencingComponentEntity clientEntity, Map<NodeIdentifier, ControllerServiceReferencingComponentEntity> nodeEntities) {
        HashMap propertyDescriptorMap = new HashMap();
        HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>> nodeReferencingComponentsMap = new HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentEntity>>();
        for (Map.Entry<NodeIdentifier, ControllerServiceReferencingComponentEntity> entry : nodeEntities.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            ControllerServiceReferencingComponentEntity nodeEntity = entry.getValue();
            nodeEntity.getComponent().getDescriptors().values().stream().forEach(propertyDescriptor -> propertyDescriptorMap.computeIfAbsent(propertyDescriptor.getName(), nodeIdToPropertyDescriptor -> new HashMap()).put(nodeIdentifier, propertyDescriptor));
            nodeReferencingComponentsMap.put(nodeIdentifier, nodeEntity.getComponent().getReferencingComponents());
        }
        for (Map propertyDescriptorByNodeId : propertyDescriptorMap.values()) {
            Collection nodePropertyDescriptors = propertyDescriptorByNodeId.values();
            if (nodePropertyDescriptors.isEmpty()) continue;
            PropertyDescriptorDTO propertyDescriptor2 = (PropertyDescriptorDTO)nodePropertyDescriptors.iterator().next();
            PropertyDescriptorDTO clientPropertyDescriptor = (PropertyDescriptorDTO)clientEntity.getComponent().getDescriptors().get(propertyDescriptor2.getName());
            PropertyDescriptorDtoMerger.merge(clientPropertyDescriptor, propertyDescriptorByNodeId);
        }
        Set referencingComponents = clientEntity.getComponent().getReferencingComponents();
        ControllerServiceEntityMerger.mergeControllerServiceReferences(referencingComponents, nodeReferencingComponentsMap);
    }
}

