/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.ControllerServicesEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.Entity;

public class ControllerServicesEndpointMerger
implements EndpointResponseMerger {
    public static final String CONTROLLER_SERVICES_URI = "/nifi-api/flow/controller/controller-services";
    public static final Pattern PROCESS_GROUPS_CONTROLLER_SERVICES_URI = Pattern.compile("/nifi-api/flow/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/controller-services");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && (CONTROLLER_SERVICES_URI.equals(uri.getPath()) || PROCESS_GROUPS_CONTROLLER_SERVICES_URI.matcher(uri.getPath()).matches());
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        ControllerServicesEntity responseEntity = (ControllerServicesEntity)clientResponse.getClientResponse().readEntity(ControllerServicesEntity.class);
        Set controllerServiceEntities = responseEntity.getControllerServices();
        HashMap<String, Map<NodeIdentifier, ControllerServiceEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, ControllerServiceEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ControllerServicesEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ControllerServicesEntity)nodeResponse.getClientResponse().readEntity(ControllerServicesEntity.class);
            Set nodeControllerServiceEntities = nodeResponseEntity.getControllerServices();
            for (ControllerServiceEntity nodeControllerServiceEntity : nodeControllerServiceEntities) {
                NodeIdentifier nodeId = nodeResponse.getNodeId();
                HashMap<NodeIdentifier, ControllerServiceEntity> innerMap = (HashMap<NodeIdentifier, ControllerServiceEntity>)entityMap.get(nodeId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, ControllerServiceEntity>();
                    entityMap.put(nodeControllerServiceEntity.getId(), innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodeControllerServiceEntity);
            }
        }
        ControllerServicesEntityMerger.mergeControllerServices(controllerServiceEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

