/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterProviderMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.ParameterProvidersEntity;

public class ParameterProvidersEndpointMerger
extends AbstractSingleEntityEndpoint<ParameterProvidersEntity>
implements EndpointResponseMerger {
    private static final Pattern PARAMETER_PROVIDER_URI = Pattern.compile("/nifi-api/flow/parameter-providers");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PARAMETER_PROVIDER_URI.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ParameterProvidersEntity> getEntityClass() {
        return ParameterProvidersEntity.class;
    }

    @Override
    protected void mergeResponses(ParameterProvidersEntity clientEntity, Map<NodeIdentifier, ParameterProvidersEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        HashMap<String, ParameterProviderEntity> providerEntities = new HashMap<String, ParameterProviderEntity>();
        for (ParameterProvidersEntity providersEntity : entityMap.values()) {
            for (ParameterProviderEntity entity : providersEntity.getParameterProviders()) {
                ParameterProviderEntity mergedEntity = (ParameterProviderEntity)providerEntities.get(entity.getId());
                if (mergedEntity == null) {
                    providerEntities.put(entity.getId(), entity);
                    continue;
                }
                ParameterProviderMerger.merge(mergedEntity, entity);
            }
        }
        clientEntity.setParameterProviders(new HashSet(providerEntities.values()));
    }
}

