/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.lifecycle;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.coordination.node.OffloadCode;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.DecommissionTask;
import org.apache.nifi.controller.FlowController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterDecommissionTask
implements DecommissionTask {
    private static final Logger logger = LoggerFactory.getLogger(ClusterDecommissionTask.class);
    private static final int delaySeconds = 3;
    private final ClusterCoordinator clusterCoordinator;
    private final FlowController flowController;
    private NodeIdentifier localNodeIdentifier;

    public ClusterDecommissionTask(ClusterCoordinator clusterCoordinator, FlowController flowController) {
        this.clusterCoordinator = clusterCoordinator;
        this.flowController = flowController;
    }

    public synchronized void decommission() throws InterruptedException {
        if (this.clusterCoordinator == null) {
            throw new IllegalStateException("Cannot decommission Node because it is not part of a cluster");
        }
        logger.info("Decommissioning Node...");
        this.localNodeIdentifier = this.clusterCoordinator.getLocalNodeIdentifier();
        if (this.localNodeIdentifier == null) {
            throw new IllegalStateException("Node has not yet connected to the cluster");
        }
        this.flowController.stopHeartbeating();
        this.flowController.setClustered(false, null);
        logger.info("Instructed FlowController to stop sending heartbeats to Cluster Coordinator and take Cluster Disconnect actions");
        this.disconnectNode();
        logger.info("Requested that node be disconnected from cluster");
        this.waitForDisconnection();
        logger.info("Successfully disconnected node from cluster");
        this.offloadNode();
        logger.info("Successfully triggered Node Offload. Will wait for offload to complete");
        this.waitForOffloadToFinish();
        logger.info("Offload has successfully completed.");
        this.removeFromCluster();
        logger.info("Requested that node be removed from cluster.");
        this.waitForRemoval();
        logger.info("Node successfully removed from cluster. Decommission is complete.");
    }

    private void disconnectNode() throws InterruptedException {
        logger.info("Requesting that Node disconnect from cluster");
        while (true) {
            Future future = this.clusterCoordinator.requestNodeDisconnect(this.localNodeIdentifier, DisconnectionCode.USER_DISCONNECTED, "Node is being decommissioned");
            try {
                future.get();
                return;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                logger.error("Failed when attempting to disconnect node from cluster", cause);
                continue;
            }
            break;
        }
    }

    private void waitForDisconnection() throws InterruptedException {
        logger.info("Waiting for Node to be completely disconnected from cluster");
        this.waitForState(Collections.singleton(NodeConnectionState.DISCONNECTED));
    }

    private void offloadNode() throws InterruptedException {
        logger.info("Requesting that Node be offloaded");
        while (true) {
            Future future = this.clusterCoordinator.requestNodeOffload(this.localNodeIdentifier, OffloadCode.OFFLOADED, "Node is being decommissioned");
            try {
                future.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                logger.error("Failed when attempting to disconnect node from cluster", cause);
                continue;
            }
            break;
        }
        this.waitForState(new HashSet<NodeConnectionState>(Arrays.asList(NodeConnectionState.OFFLOADING, NodeConnectionState.OFFLOADED)));
    }

    private void waitForState(Set<NodeConnectionState> acceptableStates) throws InterruptedException {
        while (true) {
            NodeConnectionStatus status = this.clusterCoordinator.getConnectionStatus(this.localNodeIdentifier);
            NodeConnectionState state = status.getState();
            logger.debug("Node state is {}", (Object)state);
            if (acceptableStates.contains(state)) {
                return;
            }
            TimeUnit.SECONDS.sleep(3L);
        }
    }

    private void waitForOffloadToFinish() throws InterruptedException {
        logger.info("Waiting for Node to finish offloading");
        NodeConnectionStatus status;
        NodeConnectionState state;
        while ((state = (status = this.clusterCoordinator.getConnectionStatus(this.localNodeIdentifier)).getState()) != NodeConnectionState.OFFLOADED) {
            if (state != NodeConnectionState.OFFLOADING) {
                throw new IllegalStateException("Expected state of Node to be OFFLOADING but Node is now in a state of " + String.valueOf(state));
            }
            logger.debug("Node state is OFFLOADING. Will wait {} seconds and check again", (Object)3);
            TimeUnit.SECONDS.sleep(3L);
        }
        return;
    }

    private void removeFromCluster() {
        this.clusterCoordinator.removeNode(this.localNodeIdentifier, "<Local Decommission>");
    }

    private void waitForRemoval() throws InterruptedException {
        logger.info("Waiting for Node to be completely removed from cluster");
        NodeConnectionStatus status;
        while ((status = this.clusterCoordinator.getConnectionStatus(this.localNodeIdentifier)) != null) {
            NodeConnectionState state = status.getState();
            if (state == NodeConnectionState.REMOVED) {
                return;
            }
            logger.debug("Node state is {}. Will wait {} seconds and check again", (Object)state, (Object)3);
            TimeUnit.SECONDS.sleep(3L);
        }
        return;
    }
}

