/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication.okhttp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.cluster.coordination.http.replication.HttpReplicationClient;
import org.apache.nifi.cluster.coordination.http.replication.PreparedRequest;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.EntitySerializer;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.JacksonResponse;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.JsonEntitySerializer;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.OkHttpPreparedRequest;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.RequestReplicationEventListener;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.XmlEntitySerializer;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class OkHttpReplicationClient
implements HttpReplicationClient {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpReplicationClient.class);
    private static final Set<String> gzipEncodings = Stream.of("gzip", "x-gzip").collect(Collectors.toSet());
    private final EntitySerializer jsonSerializer;
    private final EntitySerializer xmlSerializer;
    private final ObjectMapper jsonCodec = new ObjectMapper();
    private final OkHttpClient okHttpClient;
    private final SSLContext sslContext;
    private final X509TrustManager trustManager;

    public OkHttpReplicationClient(NiFiProperties properties, SSLContext sslContext, X509TrustManager trustManager) {
        this.jsonCodec.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        this.jsonCodec.setAnnotationIntrospector((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(this.jsonCodec.getTypeFactory()));
        this.jsonSerializer = new JsonEntitySerializer(this.jsonCodec);
        this.xmlSerializer = new XmlEntitySerializer();
        this.sslContext = sslContext;
        this.trustManager = trustManager;
        this.okHttpClient = this.createOkHttpClient(properties);
    }

    @Override
    public PreparedRequest prepareRequest(String method, Map<String, String> headers, Object entity) {
        boolean gzip = this.isUseGzip(headers);
        this.checkContentLengthHeader(method, headers);
        RequestBody requestBody = this.createRequestBody(headers, entity, gzip);
        Map<String, String> updatedHeaders = gzip ? this.updateHeadersForGzip(headers) : headers;
        return new OkHttpPreparedRequest(method, updatedHeaders, entity, requestBody);
    }

    private void checkContentLengthHeader(String method, Map<String, String> headers) {
        if ("DELETE".equalsIgnoreCase(method)) {
            String CONTENT_LENGTH_HEADER_KEY = "Content-Length";
            Map.Entry contentLengthEntry = headers.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("Content-Length")).findFirst().orElse(null);
            if (contentLengthEntry != null && contentLengthEntry.getValue() != null && !((String)contentLengthEntry.getValue()).equalsIgnoreCase("0")) {
                logger.warn("This is a DELETE request; the provided Content-Length was {}; setting Content-Length to 0", contentLengthEntry.getValue());
                headers.put("Content-Length", "0");
            }
        }
    }

    @Override
    public Response replicate(PreparedRequest request, String uri) throws IOException {
        if (!(Objects.requireNonNull(request) instanceof OkHttpPreparedRequest)) {
            throw new IllegalArgumentException("Replication Client is only able to replicate requests that the client itself has prepared");
        }
        return this.replicate((OkHttpPreparedRequest)request, uri);
    }

    private Response replicate(OkHttpPreparedRequest request, String uri) throws IOException {
        logger.debug("Replicating request {} to {}", (Object)request, (Object)uri);
        Call call = this.createCall(request, uri);
        okhttp3.Response callResponse = call.execute();
        byte[] responseBytes = this.getResponseBytes(callResponse);
        MultivaluedMap<String, String> responseHeaders = this.getHeaders(callResponse);
        logger.debug("Received response code {} with headers {} for request {} to {}", new Object[]{callResponse.code(), responseHeaders, request, uri});
        JacksonResponse response = new JacksonResponse(this.jsonCodec, responseBytes, responseHeaders, URI.create(uri), callResponse.code(), () -> ((okhttp3.Response)callResponse).close());
        return response;
    }

    private MultivaluedMap<String, String> getHeaders(okhttp3.Response callResponse) {
        Headers headers = callResponse.headers();
        MultivaluedHashMap headerMap = new MultivaluedHashMap();
        for (String name : headers.names()) {
            List values = headers.values(name);
            headerMap.addAll((Object)name, values);
        }
        return headerMap;
    }

    private byte[] getResponseBytes(okhttp3.Response callResponse) throws IOException {
        byte[] rawBytes = callResponse.body().bytes();
        String contentEncoding = callResponse.header("Content-Encoding");
        if (gzipEncodings.contains(contentEncoding)) {
            try (GZIPInputStream gzipIn = new GZIPInputStream(new ByteArrayInputStream(rawBytes));){
                byte[] byArray;
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    StreamUtils.copy((InputStream)gzipIn, (OutputStream)baos);
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
        }
        return rawBytes;
    }

    /*
     * WARNING - void declaration
     */
    private Call createCall(OkHttpPreparedRequest request, String uri) {
        void var7_11;
        Request.Builder requestBuilder = new Request.Builder();
        HttpUrl url = this.buildUrl(request, uri);
        requestBuilder = requestBuilder.url(url);
        String method = request.getMethod().toUpperCase();
        String string = method;
        int n = -1;
        switch (string.hashCode()) {
            case 2461856: {
                if (!string.equals("POST")) break;
                boolean bl = false;
                break;
            }
            case 79599: {
                if (!string.equals("PUT")) break;
                boolean bl = true;
                break;
            }
            case 75900968: {
                if (!string.equals("PATCH")) break;
                int n2 = 2;
            }
        }
        switch (var7_11) {
            case 0: 
            case 1: 
            case 2: {
                requestBuilder = requestBuilder.method(method, request.getRequestBody());
                break;
            }
            default: {
                requestBuilder = requestBuilder.method(method, null);
            }
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            requestBuilder = requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        Request okHttpRequest = requestBuilder.build();
        Call call = this.okHttpClient.newCall(okHttpRequest);
        return call;
    }

    private HttpUrl buildUrl(OkHttpPreparedRequest request, String uri) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)uri).newBuilder();
        switch (request.getMethod().toUpperCase()) {
            case "DELETE": 
            case "HEAD": 
            case "GET": 
            case "OPTIONS": {
                if (!(request.getEntity() instanceof MultivaluedMap)) break;
                MultivaluedMap entityMap = (MultivaluedMap)request.getEntity();
                for (Map.Entry queryEntry : entityMap.entrySet()) {
                    String queryName = (String)queryEntry.getKey();
                    for (String queryValue : (List)queryEntry.getValue()) {
                        urlBuilder = urlBuilder.addQueryParameter(queryName, queryValue);
                    }
                }
                break;
            }
        }
        return urlBuilder.build();
    }

    private RequestBody createRequestBody(Map<String, String> headers, Object entity, boolean gzip) {
        String contentType = this.getContentType(headers, "application/json");
        byte[] serialized = this.serializeEntity(entity, contentType, gzip);
        MediaType mediaType = MediaType.parse((String)contentType);
        return RequestBody.create((byte[])serialized, (MediaType)mediaType);
    }

    private String getContentType(Map<String, String> headers, String defaultValue) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("content-type")) continue;
            return entry.getValue();
        }
        return defaultValue;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeEntity(Object entity, String contentType, boolean gzip) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                ByteArrayOutputStream out = gzip ? new GZIPOutputStream((OutputStream)baos, 1) : baos;
                try {
                    this.getSerializer(contentType).serialize(entity, out);
                    ((OutputStream)out).close();
                    byArray = baos.toByteArray();
                    if (out == null) break block13;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((OutputStream)out).close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize entity for cluster replication", e);
        }
    }

    private EntitySerializer getSerializer(String contentType) {
        switch (contentType.toLowerCase()) {
            case "application/xml": {
                return this.xmlSerializer;
            }
        }
        return this.jsonSerializer;
    }

    private Map<String, String> updateHeadersForGzip(Map<String, String> headers) {
        String encodingHeader = headers.get("Content-Encoding");
        if (gzipEncodings.contains(encodingHeader)) {
            return headers;
        }
        HashMap<String, String> updatedHeaders = new HashMap<String, String>(headers);
        updatedHeaders.put("Content-Encoding", "gzip");
        return updatedHeaders;
    }

    private boolean isUseGzip(Map<String, String> headers) {
        String rawAcceptEncoding = headers.get("Accept-Encoding");
        if (rawAcceptEncoding == null) {
            rawAcceptEncoding = headers.get("Accept-Encoding".toLowerCase());
        }
        if (rawAcceptEncoding == null) {
            return false;
        }
        String[] acceptEncodingTokens = rawAcceptEncoding.split(",");
        return Stream.of(acceptEncodingTokens).map(String::trim).filter(StringUtils::isNotEmpty).map(String::toLowerCase).anyMatch(gzipEncodings::contains);
    }

    private OkHttpClient createOkHttpClient(NiFiProperties properties) {
        String connectionTimeout = properties.getClusterNodeConnectionTimeout();
        long connectionTimeoutMs = (long)FormatUtils.getPreciseTimeDuration((String)connectionTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        String readTimeout = properties.getClusterNodeReadTimeout();
        long readTimeoutMs = (long)FormatUtils.getPreciseTimeDuration((String)readTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient().newBuilder();
        okHttpClientBuilder.connectTimeout(connectionTimeoutMs, TimeUnit.MILLISECONDS);
        okHttpClientBuilder.readTimeout(readTimeoutMs, TimeUnit.MILLISECONDS);
        okHttpClientBuilder.followRedirects(true);
        int connectionPoolSize = properties.getClusterNodeMaxConcurrentRequests();
        okHttpClientBuilder.connectionPool(new ConnectionPool(connectionPoolSize, 5L, TimeUnit.MINUTES));
        okHttpClientBuilder.eventListener((EventListener)new RequestReplicationEventListener());
        if (this.sslContext != null) {
            SSLSocketFactory sslSocketFactory = this.sslContext.getSocketFactory();
            okHttpClientBuilder.sslSocketFactory(sslSocketFactory, this.trustManager);
        }
        return okHttpClientBuilder.build();
    }
}

