/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.cluster.ClusterDetailsFactory;
import org.apache.nifi.cluster.StandardClusterDetailsFactory;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestCompletionCallback;
import org.apache.nifi.cluster.coordination.http.replication.ThreadPoolRequestReplicator;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.OkHttpReplicationClient;
import org.apache.nifi.cluster.lifecycle.ClusterDecommissionTask;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FrameworkClusterConfiguration {
    private NiFiProperties properties;
    private EventReporter eventReporter;
    private FlowController flowController;
    private ClusterCoordinator clusterCoordinator;

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    @Autowired
    public void setEventReporter(EventReporter eventReporter) {
        this.eventReporter = eventReporter;
    }

    @Autowired
    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    @Bean
    public ThreadPoolRequestReplicator requestReplicator(@Autowired(required=false) SSLContext sslContext, @Autowired(required=false) X509TrustManager trustManager) {
        ThreadPoolRequestReplicator replicator;
        if (this.clusterCoordinator == null) {
            replicator = null;
        } else {
            OkHttpReplicationClient replicationClient = new OkHttpReplicationClient(this.properties, sslContext, trustManager);
            replicator = new ThreadPoolRequestReplicator(this.properties.getClusterNodeProtocolMaxPoolSize(), this.properties.getClusterNodeMaxConcurrentRequests(), replicationClient, this.clusterCoordinator, (RequestCompletionCallback)this.clusterCoordinator, this.eventReporter, this.properties);
        }
        return replicator;
    }

    @Bean
    public ClusterDecommissionTask decommissionTask() {
        return new ClusterDecommissionTask(this.clusterCoordinator, this.flowController);
    }

    @Bean
    public ClusterDetailsFactory clusterDetailsFactory() {
        return new StandardClusterDetailsFactory(this.clusterCoordinator);
    }
}

