/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import org.apache.commons.lang3.StringUtils;

public class NodeIdentifier {
    private final String id;
    private final String apiAddress;
    private final int apiPort;
    private final String socketAddress;
    private final int socketPort;
    private final String nodeDn;

    public NodeIdentifier(String id, String apiAddress, int apiPort, String socketAddress, int socketPort) {
        this(id, apiAddress, apiPort, socketAddress, socketPort, null);
    }

    public NodeIdentifier(String id, String apiAddress, int apiPort, String socketAddress, int socketPort, String dn) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Node ID may not be empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)apiAddress)) {
            throw new IllegalArgumentException("Node API address may not be empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)socketAddress)) {
            throw new IllegalArgumentException("Node socket address may not be empty or null.");
        }
        this.validatePort(apiPort);
        this.validatePort(socketPort);
        this.id = id;
        this.apiAddress = apiAddress;
        this.apiPort = apiPort;
        this.socketAddress = socketAddress;
        this.socketPort = socketPort;
        this.nodeDn = dn;
    }

    public String getId() {
        return this.id;
    }

    public String getDN() {
        return this.nodeDn;
    }

    public String getApiAddress() {
        return this.apiAddress;
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public String getSocketAddress() {
        return this.socketAddress;
    }

    public int getSocketPort() {
        return this.socketPort;
    }

    private void validatePort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port must be inclusively in the range [1, 65535].  Port given: " + port);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeIdentifier other = (NodeIdentifier)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean logicallyEquals(NodeIdentifier other) {
        if (other == null) {
            return false;
        }
        if (this.apiAddress == null ? other.apiAddress != null : !this.apiAddress.equals(other.apiAddress)) {
            return false;
        }
        if (this.apiPort != other.apiPort) {
            return false;
        }
        if (this.socketAddress == null ? other.socketAddress != null : !this.socketAddress.equals(other.socketAddress)) {
            return false;
        }
        return this.socketPort == other.socketPort;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "[id=" + this.id + ", apiAddress=" + this.apiAddress + ", apiPort=" + this.apiPort + ", socketAddress=" + this.socketAddress + ", socketPort=" + this.socketPort + ']';
    }
}

