/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.io.Serializable;
import java.util.Arrays;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.jaxb.message.DataFlowAdapter;

@XmlJavaTypeAdapter(value=DataFlowAdapter.class)
public class StandardDataFlow
implements Serializable,
DataFlow {
    private static final long serialVersionUID = 1L;
    private final byte[] flow;
    private final byte[] snippetBytes;
    private final byte[] authorizerFingerprint;

    public StandardDataFlow(byte[] flow, byte[] snippetBytes, byte[] authorizerFingerprint) {
        if (flow == null) {
            throw new NullPointerException("Flow cannot be null");
        }
        this.flow = flow;
        this.snippetBytes = snippetBytes;
        this.authorizerFingerprint = authorizerFingerprint;
    }

    public StandardDataFlow(DataFlow toCopy) {
        this.flow = StandardDataFlow.copy(toCopy.getFlow());
        this.snippetBytes = StandardDataFlow.copy(toCopy.getSnippets());
        this.authorizerFingerprint = StandardDataFlow.copy(toCopy.getAuthorizerFingerprint());
    }

    private static byte[] copy(byte[] bytes) {
        return bytes == null ? null : Arrays.copyOf(bytes, bytes.length);
    }

    public byte[] getFlow() {
        return this.flow;
    }

    public byte[] getSnippets() {
        return this.snippetBytes;
    }

    public byte[] getAuthorizerFingerprint() {
        return this.authorizerFingerprint;
    }
}

