/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.spring;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.io.socket.SSLContextFactory;
import org.apache.nifi.io.socket.SocketConfiguration;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.factory.FactoryBean;

public class SocketConfigurationFactoryBean
implements FactoryBean<SocketConfiguration> {
    private SocketConfiguration configuration;
    private NiFiProperties properties;

    public SocketConfiguration getObject() throws Exception {
        if (this.configuration == null) {
            this.configuration = new SocketConfiguration();
            int timeout = (int)FormatUtils.getTimeDuration((String)this.properties.getClusterNodeReadTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
            this.configuration.setSocketTimeout(Integer.valueOf(timeout));
            this.configuration.setReuseAddress(Boolean.valueOf(true));
            if (Boolean.valueOf(this.properties.getProperty("nifi.cluster.protocol.is.secure")).booleanValue()) {
                this.configuration.setSSLContextFactory(new SSLContextFactory(this.properties));
            }
        }
        return this.configuration;
    }

    public Class<SocketConfiguration> getObjectType() {
        return SocketConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

