/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.jaxb.message.DataFlowAdapter;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.security.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@XmlJavaTypeAdapter(value=DataFlowAdapter.class)
public class StandardDataFlow
implements Serializable,
DataFlow {
    private static final URL FLOW_XSD_RESOURCE = StandardDataFlow.class.getClassLoader().getResource("/FlowConfiguration.xsd");
    private static final Logger logger = LoggerFactory.getLogger(StandardDataFlow.class);
    private static final long serialVersionUID = 1L;
    private final byte[] flow;
    private final byte[] snippetBytes;
    private final byte[] authorizerFingerprint;
    private final Set<String> missingComponentIds;
    private Document flowDocument;

    public StandardDataFlow(byte[] flow, byte[] snippetBytes, byte[] authorizerFingerprint, Set<String> missingComponentIds) {
        if (flow == null) {
            throw new NullPointerException("Flow cannot be null");
        }
        this.flow = flow;
        this.snippetBytes = snippetBytes;
        this.authorizerFingerprint = authorizerFingerprint;
        this.missingComponentIds = Collections.unmodifiableSet(missingComponentIds == null ? new HashSet() : new HashSet<String>(missingComponentIds));
    }

    public StandardDataFlow(DataFlow toCopy) {
        this.flow = StandardDataFlow.copy(toCopy.getFlow());
        this.snippetBytes = StandardDataFlow.copy(toCopy.getSnippets());
        this.authorizerFingerprint = StandardDataFlow.copy(toCopy.getAuthorizerFingerprint());
        this.missingComponentIds = Collections.unmodifiableSet(toCopy.getMissingComponents() == null ? new HashSet() : new HashSet(toCopy.getMissingComponents()));
    }

    private static byte[] copy(byte[] bytes) {
        return bytes == null ? null : Arrays.copyOf(bytes, bytes.length);
    }

    public byte[] getFlow() {
        return this.flow;
    }

    public synchronized Document getFlowDocument() {
        if (this.flowDocument == null) {
            this.flowDocument = StandardDataFlow.parseFlowBytes(this.flow);
        }
        return this.flowDocument;
    }

    public byte[] getSnippets() {
        return this.snippetBytes;
    }

    public byte[] getAuthorizerFingerprint() {
        return this.authorizerFingerprint;
    }

    public Set<String> getMissingComponents() {
        return this.missingComponentIds;
    }

    private static Document parseFlowBytes(byte[] flow) throws FlowSerializationException {
        if (flow == null || flow.length == 0) {
            return null;
        }
        try {
            DocumentBuilder docBuilder = XmlUtils.createSafeDocumentBuilder((boolean)true);
            docBuilder.setErrorHandler(new DefaultHandler(){

                @Override
                public void error(SAXParseException e) {
                    logger.warn("Schema validation error parsing Flow Configuration at line {}, col {}: {}", new Object[]{e.getLineNumber(), e.getColumnNumber(), e.getMessage()});
                }
            });
            return docBuilder.parse(new ByteArrayInputStream(flow));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new FlowSerializationException((Throwable)ex);
        }
    }
}

