/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.node;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.jaxb.message.NodeConnectionStatusAdapter;

@XmlJavaTypeAdapter(value=NodeConnectionStatusAdapter.class)
public class NodeConnectionStatus {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final long updateId;
    private final NodeIdentifier nodeId;
    private final NodeConnectionState state;
    private final DisconnectionCode disconnectCode;
    private final String disconnectReason;
    private final Long connectionRequestTime;

    public NodeConnectionStatus(NodeIdentifier nodeId, NodeConnectionState state) {
        this(nodeId, state, null, null, null);
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, DisconnectionCode disconnectionCode) {
        this(nodeId, NodeConnectionState.DISCONNECTED, disconnectionCode, disconnectionCode.toString(), null);
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, DisconnectionCode disconnectionCode, String disconnectionExplanation) {
        this(nodeId, NodeConnectionState.DISCONNECTED, disconnectionCode, disconnectionExplanation, null);
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, NodeConnectionState state, DisconnectionCode disconnectionCode) {
        this(nodeId, state, disconnectionCode, disconnectionCode == null ? null : disconnectionCode.toString(), null);
    }

    public NodeConnectionStatus(NodeConnectionStatus status) {
        this(status.getNodeIdentifier(), status.getState(), status.getDisconnectCode(), status.getDisconnectReason(), status.getConnectionRequestTime());
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, NodeConnectionState state, DisconnectionCode disconnectCode, String disconnectReason, Long connectionRequestTime) {
        this(idGenerator.getAndIncrement(), nodeId, state, disconnectCode, disconnectReason, connectionRequestTime);
    }

    public NodeConnectionStatus(long updateId, NodeIdentifier nodeId, NodeConnectionState state, DisconnectionCode disconnectCode, String disconnectReason, Long connectionRequestTime) {
        this.updateId = updateId;
        this.nodeId = nodeId;
        this.state = state;
        if (state == NodeConnectionState.DISCONNECTED && disconnectCode == null) {
            this.disconnectCode = DisconnectionCode.UNKNOWN;
            this.disconnectReason = this.disconnectCode.toString();
        } else {
            this.disconnectCode = disconnectCode;
            this.disconnectReason = disconnectReason;
        }
        this.connectionRequestTime = connectionRequestTime == null && state == NodeConnectionState.CONNECTING ? Long.valueOf(System.currentTimeMillis()) : connectionRequestTime;
    }

    public long getUpdateIdentifier() {
        return this.updateId;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeId;
    }

    public NodeConnectionState getState() {
        return this.state;
    }

    public DisconnectionCode getDisconnectCode() {
        return this.disconnectCode;
    }

    public String getDisconnectReason() {
        return this.disconnectReason;
    }

    public Long getConnectionRequestTime() {
        return this.connectionRequestTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NodeConnectionState state = this.getState();
        sb.append("NodeConnectionStatus[nodeId=").append(this.nodeId).append(", state=").append((Object)state);
        if (state == NodeConnectionState.DISCONNECTED || state == NodeConnectionState.DISCONNECTING) {
            sb.append(", Disconnect Code=").append((Object)this.getDisconnectCode()).append(", Disconnect Reason=").append(this.getDisconnectReason());
        }
        sb.append(", updateId=").append(this.getUpdateIdentifier());
        sb.append("]");
        return sb.toString();
    }

    static void updateIdGenerator(long minimumValue) {
        idGenerator.updateAndGet(curValue -> Math.max(minimumValue, curValue));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConnectionStatus)) {
            return false;
        }
        NodeConnectionStatus other = (NodeConnectionStatus)obj;
        return Objects.deepEquals(this.getNodeIdentifier(), other.getNodeIdentifier()) && Objects.deepEquals((Object)this.getState(), (Object)other.getState());
    }
}

