/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.cluster.coordination.node.LeaderElectionNodeProtocolSender;
import org.apache.nifi.cluster.protocol.ClusterCoordinationProtocolSender;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.impl.ClusterCoordinationProtocolSenderListener;
import org.apache.nifi.cluster.protocol.impl.NodeProtocolSenderListener;
import org.apache.nifi.cluster.protocol.impl.SocketProtocolListener;
import org.apache.nifi.cluster.protocol.impl.StandardClusterCoordinationProtocolSender;
import org.apache.nifi.cluster.protocol.jaxb.JaxbProtocolContext;
import org.apache.nifi.cluster.protocol.jaxb.message.JaxbProtocolUtils;
import org.apache.nifi.cluster.protocol.message.ProtocolMessage;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.io.socket.ServerSocketConfiguration;
import org.apache.nifi.io.socket.SocketConfiguration;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FrameworkClusterProtocolConfiguration {
    private NiFiProperties properties;
    private SSLContext sslContext;
    private LeaderElectionManager leaderElectionManager;

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Autowired(required=false)
    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Autowired
    public void setLeaderElectionManager(LeaderElectionManager leaderElectionManager) {
        this.leaderElectionManager = leaderElectionManager;
    }

    @Bean
    public JaxbProtocolContext<ProtocolMessage> protocolContext() {
        return new JaxbProtocolContext<ProtocolMessage>(JaxbProtocolUtils.JAXB_CONTEXT);
    }

    @Bean
    public SocketConfiguration protocolSocketConfiguration() {
        SocketConfiguration configuration = new SocketConfiguration();
        int timeout = (int)FormatUtils.getPreciseTimeDuration((String)this.properties.getClusterNodeReadTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
        configuration.setSocketTimeout(Integer.valueOf(timeout));
        configuration.setReuseAddress(Boolean.valueOf(true));
        configuration.setSslContext(this.sslContext);
        return configuration;
    }

    @Bean
    public ServerSocketConfiguration protocolServerSocketConfiguration() {
        ServerSocketConfiguration configuration = new ServerSocketConfiguration();
        configuration.setNeedClientAuth(true);
        int timeout = (int)FormatUtils.getPreciseTimeDuration((String)this.properties.getClusterNodeReadTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
        configuration.setSocketTimeout(Integer.valueOf(timeout));
        configuration.setReuseAddress(Boolean.valueOf(true));
        configuration.setSslContext(this.sslContext);
        return configuration;
    }

    @Bean
    public ClusterCoordinationProtocolSender clusterCoordinationProtocolSender() {
        StandardClusterCoordinationProtocolSender sender = new StandardClusterCoordinationProtocolSender(this.protocolSocketConfiguration(), this.protocolContext(), this.properties.getClusterNodeProtocolMaxPoolSize());
        sender.setHandshakeTimeout(this.properties.getClusterNodeConnectionTimeout());
        return sender;
    }

    @Bean
    public ClusterCoordinationProtocolSenderListener clusterCoordinationProtocolSenderListener() {
        return new ClusterCoordinationProtocolSenderListener(this.clusterCoordinationProtocolSender(), this.protocolListener());
    }

    @Bean
    public ProtocolListener protocolListener() {
        Integer protocolPort = this.properties.getClusterNodeProtocolPort();
        int clusterNodeProtocolPort = protocolPort == null ? 0 : protocolPort;
        return new SocketProtocolListener(this.properties.getClusterNodeProtocolMaxPoolSize(), clusterNodeProtocolPort, this.protocolServerSocketConfiguration(), this.protocolContext());
    }

    @Bean
    public NodeProtocolSenderListener nodeProtocolSenderListener() {
        return new NodeProtocolSenderListener(this.nodeProtocolSender(), this.protocolListener());
    }

    @Bean
    public NodeProtocolSender nodeProtocolSender() {
        return new LeaderElectionNodeProtocolSender(this.protocolSocketConfiguration(), this.protocolContext(), this.leaderElectionManager);
    }
}

