/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.Template;
import org.apache.nifi.persistence.TemplateDeserializer;
import org.apache.nifi.persistence.TemplateSerializer;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManager {
    private static final Logger logger = LoggerFactory.getLogger(TemplateManager.class);
    private final Path directory;
    private final Map<String, Template> templateMap = new HashMap<String, Template>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final FileFilter templateFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().toLowerCase().endsWith(".template");
        }
    };

    public TemplateManager(Path storageLocation) throws IOException {
        this.directory = storageLocation;
        if (!Files.exists(this.directory, new LinkOption[0])) {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        } else {
            if (!Files.isDirectory(this.directory, new LinkOption[0])) {
                throw new IllegalArgumentException(this.directory.toString() + " is not a directory");
            }
            if (!this.directory.toFile().canExecute() || !this.directory.toFile().canWrite()) {
                throw new IOException("Invalid permissions for directory " + this.directory.toString());
            }
        }
    }

    public Template addTemplate(TemplateDTO dto) throws IOException {
        this.scrubTemplate(dto.getSnippet());
        return this.importTemplate(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyCanImport(TemplateDTO dto) {
        if (dto == null || dto.getSnippet() == null) {
            throw new IllegalArgumentException("Template details not specified.");
        }
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            throw new IllegalArgumentException("Template name cannot be blank.");
        }
        this.readLock.lock();
        try {
            for (Template template : this.templateMap.values()) {
                TemplateDTO existingDto = template.getDetails();
                if (!dto.getName().equals(existingDto.getName())) continue;
                throw new IllegalStateException(String.format("A template named '%s' already exists.", dto.getName()));
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        this.writeLock.lock();
        try {
            this.templateMap.clear();
            File[] files = this.directory.toFile().listFiles(this.templateFileFilter);
            if (files == null) {
                return;
            }
            for (File file : files) {
                boolean successful = false;
                for (int i = 0; i < 10; ++i) {
                    if (!file.delete()) continue;
                    successful = true;
                    break;
                }
                if (successful || !file.exists()) continue;
                throw new IOException("Failed to delete template file " + file.getAbsolutePath());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getTemplate(String id) {
        this.readLock.lock();
        try {
            Template template = this.templateMap.get(id);
            return template;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTemplates() throws IOException {
        this.writeLock.lock();
        try {
            File[] files = this.directory.toFile().listFiles(this.templateFileFilter);
            if (files == null) {
                return;
            }
            for (File file : files) {
                try (FileInputStream fis = new FileInputStream(file);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    TemplateDTO templateDto = TemplateDeserializer.deserialize(bis);
                    this.templateMap.put(templateDto.getId(), new Template(templateDto));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template importTemplate(TemplateDTO dto) throws IOException {
        this.verifyCanImport(dto);
        this.writeLock.lock();
        try {
            if (Objects.requireNonNull(dto).getId() == null) {
                dto.setId(UUID.randomUUID().toString());
            }
            Template template = new Template(dto);
            this.persistTemplate(template);
            this.templateMap.put(dto.getId(), template);
            Template template2 = template;
            return template2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void persistTemplate(Template template) throws IOException {
        Path path = this.directory.resolve(template.getDetails().getId() + ".template");
        Files.write(path, TemplateSerializer.serialize(template.getDetails()), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    }

    private void scrubTemplate(FlowSnippetDTO snippet) {
        if (snippet != null) {
            if (snippet.getProcessors() != null) {
                this.scrubProcessors(snippet.getProcessors());
            }
            if (snippet.getConnections() != null) {
                this.scrubConnections(snippet.getConnections());
            }
            if (snippet.getRemoteProcessGroups() != null) {
                this.scrubRemoteProcessGroups(snippet.getRemoteProcessGroups());
            }
            if (snippet.getProcessGroups() != null) {
                this.scrubProcessGroups(snippet.getProcessGroups());
            }
        }
    }

    private void scrubProcessGroups(Set<ProcessGroupDTO> processGroups) {
        for (ProcessGroupDTO processGroupDTO : processGroups) {
            this.scrubTemplate(processGroupDTO.getContents());
        }
    }

    private void scrubProcessors(Set<ProcessorDTO> processors) {
        for (ProcessorDTO processorDTO : processors) {
            ProcessorConfigDTO processorConfig = processorDTO.getConfig();
            if (processorConfig != null) {
                if (processorConfig.getProperties() != null) {
                    Map processorProperties = processorConfig.getProperties();
                    if (processorConfig.getDescriptors() != null) {
                        Collection descriptors = processorConfig.getDescriptors().values();
                        for (ProcessorConfigDTO.PropertyDescriptorDTO descriptor : descriptors) {
                            if (!descriptor.isSensitive()) continue;
                            processorProperties.put(descriptor.getName(), null);
                        }
                    }
                }
                processorConfig.setDescriptors(null);
                processorConfig.setCustomUiUrl(null);
            }
            processorDTO.setValidationErrors(null);
        }
    }

    private void scrubConnections(Set<ConnectionDTO> connections) {
        for (ConnectionDTO connectionDTO : connections) {
            connectionDTO.setAvailableRelationships(null);
            this.scrubConnectable(connectionDTO.getSource());
            this.scrubConnectable(connectionDTO.getDestination());
        }
    }

    private void scrubConnectable(ConnectableDTO connectable) {
        if (connectable != null) {
            connectable.setComments(null);
            connectable.setExists(null);
            connectable.setRunning(null);
            connectable.setTransmitting(null);
            connectable.setName(null);
        }
    }

    private void scrubRemoteProcessGroups(Set<RemoteProcessGroupDTO> remoteGroups) {
        for (RemoteProcessGroupDTO remoteProcessGroupDTO : remoteGroups) {
            remoteProcessGroupDTO.setFlowRefreshed(null);
            remoteProcessGroupDTO.setInputPortCount(null);
            remoteProcessGroupDTO.setOutputPortCount(null);
            remoteProcessGroupDTO.setTransmitting(null);
            if (remoteProcessGroupDTO.getContents() == null) continue;
            RemoteProcessGroupContentsDTO contents = remoteProcessGroupDTO.getContents();
            if (contents.getInputPorts() != null) {
                this.scrubRemotePorts(contents.getInputPorts());
            }
            if (contents.getOutputPorts() == null) continue;
            this.scrubRemotePorts(contents.getOutputPorts());
        }
    }

    private void scrubRemotePorts(Set<RemoteProcessGroupPortDTO> remotePorts) {
        Iterator<RemoteProcessGroupPortDTO> remotePortIter = remotePorts.iterator();
        while (remotePortIter.hasNext()) {
            RemoteProcessGroupPortDTO remotePortDTO = remotePortIter.next();
            if (remotePortDTO.isConnected() == null || !remotePortDTO.isConnected().booleanValue()) {
                remotePortIter.remove();
                continue;
            }
            remotePortDTO.setExists(null);
            remotePortDTO.setTargetRunning(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplate(String id) throws IOException, IllegalStateException {
        this.writeLock.lock();
        try {
            Template removed = this.templateMap.remove(Objects.requireNonNull(id));
            if (removed == null) {
                throw new IllegalStateException("No template with ID " + id + " exists");
            }
            try {
                Path path = this.directory.resolve(removed.getDetails().getId() + ".template");
                Files.delete(path);
            }
            catch (NoSuchFileException e) {
                logger.warn(String.format("Template file for template %s not found when attempting to remove. Continuing...", id));
            }
            catch (IOException e) {
                logger.error(String.format("Unable to remove template file for template %s.", id));
                this.templateMap.put(id, removed);
                throw e;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Template> getTemplates() {
        this.readLock.lock();
        try {
            HashSet<Template> hashSet = new HashSet<Template>(this.templateMap.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static List<Template> parseBytes(byte[] bytes) {
        ArrayList<Template> templates = new ArrayList<Template>();
        try (ByteArrayInputStream rawIn = new ByteArrayInputStream(bytes);
             DataInputStream in = new DataInputStream((InputStream)rawIn);){
            while (TemplateManager.isMoreData(in)) {
                int length = in.readInt();
                byte[] buffer = new byte[length];
                StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)true);
                TemplateDTO dto = TemplateDeserializer.deserialize((InputStream)new ByteArrayInputStream(buffer));
                templates.add(new Template(dto));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse bytes", e);
        }
        return templates;
    }

    private static boolean isMoreData(InputStream in) throws IOException {
        in.mark(1);
        int nextByte = in.read();
        if (nextByte == -1) {
            return false;
        }
        in.reset();
        return true;
    }

    /*
     * Exception decompiling
     */
    public byte[] export() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

