/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.controller.AbstractConfiguredComponent;
import org.apache.nifi.controller.Availability;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;

public abstract class AbstractReportingTaskNode
extends AbstractConfiguredComponent
implements ReportingTaskNode {
    private final ReportingTask reportingTask;
    private final ProcessScheduler processScheduler;
    private final ControllerServiceLookup serviceLookup;
    private final AtomicReference<SchedulingStrategy> schedulingStrategy = new AtomicReference<SchedulingStrategy>(SchedulingStrategy.TIMER_DRIVEN);
    private final AtomicReference<String> schedulingPeriod = new AtomicReference<String>("5 mins");
    private final AtomicReference<Availability> availability = new AtomicReference<Availability>(Availability.NODE_ONLY);

    public AbstractReportingTaskNode(ReportingTask reportingTask, String id, ControllerServiceProvider controllerServiceProvider, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory) {
        super((ConfigurableComponent)reportingTask, id, validationContextFactory, controllerServiceProvider);
        this.reportingTask = reportingTask;
        this.processScheduler = processScheduler;
        this.serviceLookup = controllerServiceProvider;
    }

    public Availability getAvailability() {
        return this.availability.get();
    }

    public void setAvailability(Availability availability) {
        this.availability.set(availability);
    }

    public void setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy.set(schedulingStrategy);
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return this.schedulingStrategy.get();
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.schedulingPeriod.get(), (TimeUnit)timeUnit);
    }

    public void setScheduldingPeriod(String schedulingPeriod) {
        this.schedulingPeriod.set(schedulingPeriod);
    }

    public ReportingTask getReportingTask() {
        return this.reportingTask;
    }

    public boolean isRunning() {
        return this.processScheduler.isScheduled((Object)this) || this.processScheduler.getActiveThreadCount((Object)this) > 0;
    }

    public ConfigurationContext getConfigurationContext() {
        return new StandardConfigurationContext((ConfiguredComponent)this, this.serviceLookup);
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Reporting Task while the Reporting Task is running");
        }
    }
}

