/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.processor.QueueSize;

public class ConnectionSwapInfo {
    private final Map<String, Map<String, QueueSize>> connectionMap = new HashMap<String, Map<String, QueueSize>>();

    public void addSwapSizeInfo(String connectionId, String swapFileLocation, QueueSize queueSize) {
        Map<String, QueueSize> queueSizeMap = this.connectionMap.get(connectionId);
        if (queueSizeMap == null) {
            queueSizeMap = new HashMap<String, QueueSize>();
            this.connectionMap.put(connectionId, queueSizeMap);
        }
        queueSizeMap.put(swapFileLocation, queueSize);
    }

    public Collection<String> getSwapFileLocations(String connectionId) {
        Map<String, QueueSize> sizeMap = this.connectionMap.get(connectionId);
        if (sizeMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(sizeMap.keySet());
    }

    public QueueSize getSwappedSize(String connectionId, String swapFileLocation) {
        Map<String, QueueSize> sizeMap = this.connectionMap.get(connectionId);
        if (sizeMap == null) {
            return null;
        }
        return sizeMap.get(swapFileLocation);
    }
}

