/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.controller.repository.io.LongHolder;

public class ByteCountingOutputStream
extends OutputStream {
    private final LongHolder bytesWrittenHolder;
    private final OutputStream out;

    public ByteCountingOutputStream(OutputStream out, LongHolder longHolder) {
        this.out = out;
        this.bytesWrittenHolder = longHolder;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.bytesWrittenHolder.increment(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.bytesWrittenHolder.increment(len);
    }

    public long getBytesWritten() {
        return this.bytesWrittenHolder.getValue();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

