/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduleState {
    private final AtomicInteger activeThreadCount = new AtomicInteger(0);
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final List<ScheduledFuture<?>> futures = new ArrayList();
    private final AtomicBoolean mustCallOnStoppedMethods = new AtomicBoolean(false);
    private volatile long lastStopTime = -1L;

    public int incrementActiveThreadCount() {
        return this.activeThreadCount.incrementAndGet();
    }

    public int decrementActiveThreadCount() {
        return this.activeThreadCount.decrementAndGet();
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount.get();
    }

    public boolean isScheduled() {
        return this.scheduled.get();
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled.set(scheduled);
        this.mustCallOnStoppedMethods.set(true);
        if (!scheduled) {
            this.lastStopTime = System.currentTimeMillis();
        }
    }

    public long getLastStopTime() {
        return this.lastStopTime;
    }

    public boolean mustCallOnStoppedMethods() {
        return this.mustCallOnStoppedMethods.getAndSet(false);
    }

    public void setFutures(List<ScheduledFuture<?>> newFutures) {
        this.futures.clear();
        this.futures.addAll(newFutures);
    }

    public List<ScheduledFuture<?>> getFutures() {
        return Collections.unmodifiableList(this.futures);
    }
}

