/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.scheduling.ProcessContextFactory;
import org.apache.nifi.controller.scheduling.ScheduleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.tasks.ContinuallyRunConnectableTask;
import org.apache.nifi.controller.tasks.ContinuallyRunProcessorTask;
import org.apache.nifi.controller.tasks.ReportingTaskWrapper;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerDrivenSchedulingAgent
implements SchedulingAgent {
    private static final Logger logger = LoggerFactory.getLogger(TimerDrivenSchedulingAgent.class);
    private final FlowController flowController;
    private final FlowEngine flowEngine;
    private final ProcessContextFactory contextFactory;
    private final StringEncryptor encryptor;
    private volatile String adminYieldDuration = "1 sec";

    public TimerDrivenSchedulingAgent(FlowController flowController, FlowEngine flowEngine, ProcessContextFactory contextFactory, StringEncryptor encryptor) {
        this.flowController = flowController;
        this.flowEngine = flowEngine;
        this.contextFactory = contextFactory;
        this.encryptor = encryptor;
    }

    @Override
    public void shutdown() {
        this.flowEngine.shutdown();
    }

    @Override
    public void schedule(ReportingTaskNode taskNode, ScheduleState scheduleState) {
        ReportingTaskWrapper reportingTaskWrapper = new ReportingTaskWrapper(taskNode, scheduleState);
        long schedulingNanos = taskNode.getSchedulingPeriod(TimeUnit.NANOSECONDS);
        ScheduledFuture<?> future = this.flowEngine.scheduleWithFixedDelay(reportingTaskWrapper, 0L, schedulingNanos, TimeUnit.NANOSECONDS);
        ArrayList futures = new ArrayList(1);
        futures.add(future);
        scheduleState.setFutures(futures);
        logger.info("{} started.", (Object)taskNode.getReportingTask());
    }

    @Override
    public void schedule(Connectable connectable, ScheduleState scheduleState) {
        Runnable runnable;
        if (connectable.getConnectableType() == ConnectableType.PROCESSOR) {
            ProcessorNode procNode = (ProcessorNode)connectable;
            ContinuallyRunProcessorTask runnableTask = new ContinuallyRunProcessorTask(this, procNode, this.flowController, this.contextFactory, scheduleState, this.encryptor);
            runnable = runnableTask;
        } else {
            runnable = new ContinuallyRunConnectableTask(this.contextFactory, connectable, scheduleState, this.encryptor);
        }
        ArrayList futures = new ArrayList();
        for (int i = 0; i < connectable.getMaxConcurrentTasks(); ++i) {
            ScheduledFuture<?> future = this.flowEngine.scheduleWithFixedDelay(runnable, 0L, connectable.getSchedulingPeriod(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            futures.add(future);
        }
        scheduleState.setFutures(futures);
        logger.info("Scheduled {} to run with {} threads", (Object)connectable, (Object)connectable.getMaxConcurrentTasks());
    }

    @Override
    public void unschedule(Connectable connectable, ScheduleState scheduleState) {
        for (ScheduledFuture<?> future : scheduleState.getFutures()) {
            future.cancel(false);
        }
        logger.info("Stopped scheduling {} to run", (Object)connectable);
    }

    @Override
    public void unschedule(ReportingTaskNode taskNode, ScheduleState scheduleState) {
        for (ScheduledFuture<?> future : scheduleState.getFutures()) {
            future.cancel(false);
        }
        logger.info("Stopped scheduling {} to run", (Object)taskNode.getReportingTask());
    }

    @Override
    public void setAdministrativeYieldDuration(String yieldDuration) {
        this.adminYieldDuration = yieldDuration;
    }

    @Override
    public String getAdministrativeYieldDuration() {
        return this.adminYieldDuration;
    }

    @Override
    public long getAdministrativeYieldDuration(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.adminYieldDuration, (TimeUnit)timeUnit);
    }

    @Override
    public void onEvent(Connectable connectable) {
    }

    @Override
    public void setMaxThreadCount(int maxThreads) {
    }
}

