/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.file.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ControllerServiceLoader {
    private static final Log logger = LogFactory.getLog(ControllerServiceLoader.class);
    private final Path serviceConfigXmlPath;

    public ControllerServiceLoader(Path serviceConfigXmlPath) throws IOException {
        File serviceConfigXmlFile = serviceConfigXmlPath.toFile();
        if (!serviceConfigXmlFile.exists() || !serviceConfigXmlFile.canRead()) {
            throw new IOException(serviceConfigXmlPath + " does not appear to exist or cannot be read. Cannot load configuration.");
        }
        this.serviceConfigXmlPath = serviceConfigXmlPath;
    }

    public List<ControllerServiceNode> loadControllerServices(ControllerServiceProvider provider) throws IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        InputStream fis = null;
        BufferedInputStream bis = null;
        documentBuilderFactory.setNamespaceAware(true);
        ArrayList<ControllerServiceNode> services = new ArrayList<ControllerServiceNode>();
        try {
            URL configurationResource = this.getClass().getResource("/ControllerServiceConfiguration.xsd");
            if (configurationResource == null) {
                throw new NullPointerException("Unable to load XML Schema for ControllerServiceConfiguration");
            }
            Schema schema = schemaFactory.newSchema(configurationResource);
            documentBuilderFactory.setSchema(schema);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void fatalError(SAXParseException err) throws SAXException {
                    logger.error((Object)("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage()));
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Error Stack Dump", (Throwable)err);
                    }
                    throw err;
                }

                @Override
                public void error(SAXParseException err) throws SAXParseException {
                    logger.error((Object)("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage()));
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Error Stack Dump", (Throwable)err);
                    }
                    throw err;
                }

                @Override
                public void warning(SAXParseException err) throws SAXParseException {
                    logger.warn((Object)(" Config file line " + err.getLineNumber() + ", uri " + err.getSystemId() + " : message : " + err.getMessage()));
                    if (logger.isDebugEnabled()) {
                        logger.warn((Object)"Warning stack dump", (Throwable)err);
                    }
                    throw err;
                }
            });
            fis = Files.newInputStream(this.serviceConfigXmlPath, StandardOpenOption.READ);
            bis = new BufferedInputStream(fis);
            if (Files.size(this.serviceConfigXmlPath) > 0L) {
                Document document = builder.parse(bis);
                NodeList servicesNodes = document.getElementsByTagName("services");
                Element servicesElement = (Element)servicesNodes.item(0);
                List<Element> serviceNodes = DomUtils.getChildElementsByTagName(servicesElement, "service");
                for (Element serviceElement : serviceNodes) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    String serviceId = DomUtils.getChild(serviceElement, "identifier").getTextContent().trim();
                    String serviceClass = DomUtils.getChild(serviceElement, "class").getTextContent().trim();
                    for (Element optionalProperty : DomUtils.getChildElementsByTagName(serviceElement, "property")) {
                        String name = optionalProperty.getAttribute("name").trim();
                        String value = optionalProperty.getTextContent().trim();
                        properties.put(name, value);
                    }
                    ControllerServiceNode serviceNode = provider.createControllerService(serviceClass, serviceId, properties);
                    services.add(serviceNode);
                    serviceNode.setDisabled(false);
                }
            }
        }
        catch (ParserConfigurationException | SAXException sxe) {
            try {
                throw new IOException(sxe);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                FileUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        FileUtils.closeQuietly((Closeable)fis);
        FileUtils.closeQuietly((Closeable)bis);
        return services;
    }
}

