/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.controller.AbstractConfiguredComponent;
import org.apache.nifi.controller.Availability;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.StandardControllerServiceReference;

public class StandardControllerServiceNode
extends AbstractConfiguredComponent
implements ControllerServiceNode {
    private final ControllerService controllerService;
    private final AtomicReference<Availability> availability = new AtomicReference<Availability>(Availability.NODE_ONLY);
    private final AtomicBoolean disabled = new AtomicBoolean(true);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<ConfiguredComponent> referencingComponents = new HashSet<ConfiguredComponent>();

    public StandardControllerServiceNode(ControllerService controllerService, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider) {
        super((ConfigurableComponent)controllerService, id, validationContextFactory, serviceProvider);
        this.controllerService = controllerService;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public void setDisabled(boolean disabled) {
        Set runningRefs;
        if (!disabled && !this.isValid()) {
            throw new IllegalStateException("Cannot enable Controller Service " + this.controllerService + " because it is not valid");
        }
        if (disabled && !(runningRefs = this.getReferences().getRunningReferences()).isEmpty()) {
            throw new IllegalStateException("Cannot disable Controller Service because it is referenced (either directly or indirectly) by " + runningRefs.size() + " different components that are currently running");
        }
        this.disabled.set(disabled);
    }

    public Availability getAvailability() {
        return this.availability.get();
    }

    public void setAvailability(Availability availability) {
        this.availability.set(availability);
    }

    public ControllerService getControllerService() {
        return this.controllerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControllerServiceReference getReferences() {
        this.readLock.lock();
        try {
            StandardControllerServiceReference standardControllerServiceReference = new StandardControllerServiceReference(this, this.referencingComponents);
            return standardControllerServiceReference;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.add(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.remove(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (!this.isDisabled()) {
            throw new IllegalStateException("Cannot modify Controller Service configuration because it is currently enabled. Please disable the Controller Service first.");
        }
    }
}

