/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.tasks;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.repository.StandardProcessSessionFactory;
import org.apache.nifi.controller.scheduling.ConnectableProcessContext;
import org.apache.nifi.controller.scheduling.ProcessContextFactory;
import org.apache.nifi.controller.scheduling.ScheduleState;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.annotation.OnStopped;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.util.Connectables;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuallyRunConnectableTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ContinuallyRunConnectableTask.class);
    private final Connectable connectable;
    private final ScheduleState scheduleState;
    private final ProcessSessionFactory sessionFactory;
    private final ConnectableProcessContext processContext;

    public ContinuallyRunConnectableTask(ProcessContextFactory contextFactory, Connectable connectable, ScheduleState scheduleState, StringEncryptor encryptor) {
        this.connectable = connectable;
        this.scheduleState = scheduleState;
        this.sessionFactory = new StandardProcessSessionFactory(contextFactory.newProcessContext(connectable, new AtomicLong(0L)));
        this.processContext = new ConnectableProcessContext(connectable, encryptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean shouldRun;
        if (!this.scheduleState.isScheduled()) {
            return;
        }
        boolean triggerWhenEmpty = this.connectable.isTriggerWhenEmpty();
        boolean bl = shouldRun = !(this.connectable.getYieldExpiration() >= System.currentTimeMillis() || !triggerWhenEmpty && !Connectables.flowFilesQueued(this.connectable) || !this.connectable.getRelationships().isEmpty() && !Connectables.anyRelationshipAvailable(this.connectable));
        if (shouldRun) {
            block47: {
                Throwable throwable;
                this.scheduleState.incrementActiveThreadCount();
                try {
                    try {
                        throwable = null;
                        try (NarCloseable ncl = NarCloseable.withNarLoader();){
                            this.connectable.onTrigger((ProcessContext)this.processContext, this.sessionFactory);
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                    }
                    catch (ProcessException pe) {
                        logger.error("{} failed to process session due to {}", (Object)this.connectable, (Object)pe.toString());
                    }
                    catch (Throwable t) {
                        logger.error("{} failed to process session due to {}", (Object)this.connectable, (Object)t.toString());
                        logger.error("", t);
                        logger.warn("{} Administratively Pausing for 10 seconds due to processing failure: {}", new Object[]{this.connectable, t.toString(), t});
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (this.scheduleState.isScheduled() || this.scheduleState.getActiveThreadCount() != 1 || !this.scheduleState.mustCallOnStoppedMethods()) break block47;
                }
                catch (Throwable throwable2) {
                    if (!this.scheduleState.isScheduled() && this.scheduleState.getActiveThreadCount() == 1 && this.scheduleState.mustCallOnStoppedMethods()) {
                        try (NarCloseable x = NarCloseable.withNarLoader();){
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, this.connectable, this.processContext);
                        }
                    }
                    this.scheduleState.decrementActiveThreadCount();
                    throw throwable2;
                }
                throwable = null;
                try (NarCloseable x = NarCloseable.withNarLoader();){
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, this.connectable, this.processContext);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            this.scheduleState.decrementActiveThreadCount();
        }
    }
}

