/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.processor.StandardPropertyValue;

public class StandardValidationContext
implements ValidationContext {
    private final ControllerServiceProvider controllerServiceProvider;
    private final Map<PropertyDescriptor, String> properties;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final String annotationData;

    public StandardValidationContext(ControllerServiceProvider controllerServiceProvider, Map<PropertyDescriptor, String> properties, String annotationData) {
        this.controllerServiceProvider = controllerServiceProvider;
        this.properties = new HashMap<PropertyDescriptor, String>(properties);
        this.annotationData = annotationData;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new StandardPropertyValue(rawValue, (ControllerServiceLookup)this.controllerServiceProvider, Query.prepare((String)rawValue));
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler();
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        ControllerServiceNode serviceNode = this.controllerServiceProvider.getControllerServiceNode(controllerService.getIdentifier());
        return new StandardValidationContext(this.controllerServiceProvider, serviceNode.getProperties(), serviceNode.getAnnotationData());
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.properties.get(property);
        return new StandardPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, (ControllerServiceLookup)this.controllerServiceProvider, this.preparedQueries.get(property));
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.controllerServiceProvider;
    }
}

