/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import org.apache.nifi.cluster.protocol.impl.NodeProtocolSenderListener;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.StandardFlowService;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StandardFlowServiceFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private FlowService flowService;
    private NiFiProperties properties;
    private StringEncryptor encryptor;

    public Object getObject() throws Exception {
        if (this.properties.isClusterManager()) {
            return null;
        }
        if (this.flowService == null) {
            FlowController flowController = (FlowController)this.applicationContext.getBean("flowController", FlowController.class);
            if (this.properties.isNode()) {
                NodeProtocolSenderListener nodeProtocolSenderListener = (NodeProtocolSenderListener)this.applicationContext.getBean("nodeProtocolSenderListener", NodeProtocolSenderListener.class);
                this.flowService = StandardFlowService.createClusteredInstance(flowController, this.properties, nodeProtocolSenderListener, this.encryptor);
            } else {
                this.flowService = StandardFlowService.createStandaloneInstance(flowController, this.properties, this.encryptor);
            }
        }
        return this.flowService;
    }

    public Class getObjectType() {
        return FlowService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setEncryptor(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }
}

