/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.nifi.controller.FlowFromDOMFactory;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FlowUnmarshaller {
    public static FlowSnippetDTO unmarshal(byte[] flowContents, StringEncryptor encryptor) throws IOException, SAXException, ParserConfigurationException {
        if (Objects.requireNonNull(flowContents).length == 0) {
            return new FlowSnippetDTO();
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        Document document = docBuilder.parse((InputStream)new ByteArrayInputStream(flowContents));
        FlowSnippetDTO flowDto = new FlowSnippetDTO();
        NodeList nodeList = document.getElementsByTagName("rootGroup");
        if (nodeList.getLength() == 0) {
            return flowDto;
        }
        if (nodeList.getLength() > 1) {
            throw new IllegalArgumentException("Contents contain multiple rootGroup elements");
        }
        HashSet<ProcessGroupDTO> rootGroupSet = new HashSet<ProcessGroupDTO>();
        flowDto.setProcessGroups(rootGroupSet);
        rootGroupSet.add(FlowFromDOMFactory.getProcessGroup(null, (Element)nodeList.item(0), encryptor));
        return flowDto;
    }
}

