/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowSerializationException;
import org.apache.nifi.controller.FlowSerializer;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RootGroupPort;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StandardFlowSerializer
implements FlowSerializer {
    private final StringEncryptor encryptor;

    public StandardFlowSerializer(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public void serialize(FlowController controller, OutputStream os) throws FlowSerializationException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootNode = doc.createElement("flowController");
            doc.appendChild(rootNode);
            this.addTextElement(rootNode, "maxTimerDrivenThreadCount", controller.getMaxTimerDrivenThreadCount());
            this.addTextElement(rootNode, "maxEventDrivenThreadCount", controller.getMaxEventDrivenThreadCount());
            this.addProcessGroup(rootNode, controller.getGroup(controller.getRootGroupId()), "rootGroup");
            DOMSource domSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(new BufferedOutputStream(os));
            TransformerFactory transformFactory = TransformerFactory.newInstance();
            Transformer transformer = transformFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, streamResult);
        }
        catch (IllegalArgumentException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | DOMException e) {
            throw new FlowSerializationException(e);
        }
    }

    private void addSize(Element parentElement, Size size) {
        Element element = parentElement.getOwnerDocument().createElement("size");
        element.setAttribute("width", String.valueOf(size.getWidth()));
        element.setAttribute("height", String.valueOf(size.getHeight()));
        parentElement.appendChild(element);
    }

    private void addPosition(Element parentElement, Position position) {
        this.addPosition(parentElement, position, "position");
    }

    private void addPosition(Element parentElement, Position position, String elementName) {
        Element element = parentElement.getOwnerDocument().createElement(elementName);
        element.setAttribute("x", String.valueOf(position.getX()));
        element.setAttribute("y", String.valueOf(position.getY()));
        parentElement.appendChild(element);
    }

    private void addProcessGroup(Element parentElement, ProcessGroup group, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        this.addTextElement(element, "id", group.getIdentifier());
        this.addTextElement(element, "name", group.getName());
        this.addPosition(element, group.getPosition());
        this.addTextElement(element, "comment", group.getComments());
        for (ProcessorNode processor : group.getProcessors()) {
            this.addProcessor(element, processor);
        }
        if (group.isRootGroup()) {
            for (Port port : group.getInputPorts()) {
                this.addRootGroupPort(element, (RootGroupPort)port, "inputPort");
            }
            for (Port port : group.getOutputPorts()) {
                this.addRootGroupPort(element, (RootGroupPort)port, "outputPort");
            }
        } else {
            for (Port port : group.getInputPorts()) {
                this.addPort(element, port, "inputPort");
            }
            for (Port port : group.getOutputPorts()) {
                this.addPort(element, port, "outputPort");
            }
        }
        for (Label label : group.getLabels()) {
            this.addLabel(element, label);
        }
        for (Funnel funnel : group.getFunnels()) {
            this.addFunnel(element, funnel);
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            this.addProcessGroup(element, childGroup, "processGroup");
        }
        for (RemoteProcessGroup remoteRef : group.getRemoteProcessGroups()) {
            this.addRemoteProcessGroup(element, remoteRef);
        }
        for (Connection connection : group.getConnections()) {
            this.addConnection(element, connection);
        }
    }

    private void addStyle(Element parentElement, Map<String, String> style) {
        Element element = parentElement.getOwnerDocument().createElement("styles");
        for (Map.Entry<String, String> entry : style.entrySet()) {
            Element styleElement = parentElement.getOwnerDocument().createElement("style");
            styleElement.setAttribute("name", entry.getKey());
            styleElement.setTextContent(entry.getValue());
            element.appendChild(styleElement);
        }
        parentElement.appendChild(element);
    }

    private void addLabel(Element parentElement, Label label) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("label");
        parentElement.appendChild(element);
        this.addTextElement(element, "id", label.getIdentifier());
        this.addPosition(element, label.getPosition());
        this.addSize(element, label.getSize());
        this.addStyle(element, label.getStyle());
        this.addTextElement(element, "value", label.getValue());
        parentElement.appendChild(element);
    }

    private void addFunnel(Element parentElement, Funnel funnel) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("funnel");
        parentElement.appendChild(element);
        this.addTextElement(element, "id", funnel.getIdentifier());
        this.addPosition(element, funnel.getPosition());
    }

    private void addRemoteProcessGroup(Element parentElement, RemoteProcessGroup remoteRef) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("remoteProcessGroup");
        parentElement.appendChild(element);
        this.addTextElement(element, "id", remoteRef.getIdentifier());
        this.addTextElement(element, "name", remoteRef.getName());
        this.addPosition(element, remoteRef.getPosition());
        this.addTextElement(element, "comment", remoteRef.getComments());
        this.addTextElement(element, "url", remoteRef.getTargetUri().toString());
        this.addTextElement(element, "timeout", remoteRef.getCommunicationsTimeout());
        this.addTextElement(element, "yieldPeriod", remoteRef.getYieldDuration());
        this.addTextElement(element, "transmitting", String.valueOf(remoteRef.isTransmitting()));
        for (RemoteGroupPort port : remoteRef.getInputPorts()) {
            if (!port.hasIncomingConnection()) continue;
            this.addRemoteGroupPort(element, port, "inputPort");
        }
        for (RemoteGroupPort port : remoteRef.getOutputPorts()) {
            if (port.getConnections().isEmpty()) continue;
            this.addRemoteGroupPort(element, port, "outputPort");
        }
        parentElement.appendChild(element);
    }

    private void addRemoteGroupPort(Element parentElement, RemoteGroupPort port, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        this.addTextElement(element, "id", port.getIdentifier());
        this.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        this.addTextElement(element, "comments", port.getComments());
        this.addTextElement(element, "scheduledState", port.getScheduledState().name());
        this.addTextElement(element, "maxConcurrentTasks", port.getMaxConcurrentTasks());
        this.addTextElement(element, "useCompression", String.valueOf(port.isUseCompression()));
        parentElement.appendChild(element);
    }

    private void addPort(Element parentElement, Port port, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        this.addTextElement(element, "id", port.getIdentifier());
        this.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        this.addTextElement(element, "comments", port.getComments());
        this.addTextElement(element, "scheduledState", port.getScheduledState().name());
        parentElement.appendChild(element);
    }

    private void addRootGroupPort(Element parentElement, RootGroupPort port, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        this.addTextElement(element, "id", port.getIdentifier());
        this.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        this.addTextElement(element, "comments", port.getComments());
        this.addTextElement(element, "scheduledState", port.getScheduledState().name());
        this.addTextElement(element, "maxConcurrentTasks", String.valueOf(port.getMaxConcurrentTasks()));
        for (String user : port.getUserAccessControl()) {
            this.addTextElement(element, "userAccessControl", user);
        }
        for (String group : port.getGroupAccessControl()) {
            this.addTextElement(element, "groupAccessControl", group);
        }
        parentElement.appendChild(element);
    }

    private void addProcessor(Element parentElement, ProcessorNode processor) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("processor");
        parentElement.appendChild(element);
        this.addTextElement(element, "id", processor.getIdentifier());
        this.addTextElement(element, "name", processor.getName());
        this.addPosition(element, processor.getPosition());
        this.addStyle(element, processor.getStyle());
        this.addTextElement(element, "comment", processor.getComments());
        this.addTextElement(element, "class", processor.getProcessor().getClass().getCanonicalName());
        this.addTextElement(element, "maxConcurrentTasks", processor.getMaxConcurrentTasks());
        this.addTextElement(element, "schedulingPeriod", processor.getSchedulingPeriod());
        this.addTextElement(element, "penalizationPeriod", processor.getPenalizationPeriod());
        this.addTextElement(element, "yieldPeriod", processor.getYieldPeriod());
        this.addTextElement(element, "bulletinLevel", processor.getBulletinLevel().toString());
        this.addTextElement(element, "lossTolerant", String.valueOf(processor.isLossTolerant()));
        this.addTextElement(element, "scheduledState", processor.getScheduledState().name());
        this.addTextElement(element, "schedulingStrategy", processor.getSchedulingStrategy().name());
        this.addTextElement(element, "runDurationNanos", processor.getRunDuration(TimeUnit.NANOSECONDS));
        for (Map.Entry entry : processor.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null && descriptor.isSensitive()) {
                value = "enc{" + this.encryptor.encrypt(value) + "}";
            }
            if (value == null) {
                value = descriptor.getDefaultValue();
            }
            Element propElement = doc.createElement("property");
            this.addTextElement(propElement, "name", descriptor.getName());
            if (value != null) {
                this.addTextElement(propElement, "value", value);
            }
            element.appendChild(propElement);
        }
        String annotationData = processor.getAnnotationData();
        if (annotationData != null) {
            this.addTextElement(element, "annotationData", annotationData);
        }
        for (Relationship rel : processor.getAutoTerminatedRelationships()) {
            this.addTextElement(element, "autoTerminatedRelationship", rel.getName());
        }
    }

    private void addConnection(Element parentElement, Connection connection) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("connection");
        parentElement.appendChild(element);
        this.addTextElement(element, "id", connection.getIdentifier());
        this.addTextElement(element, "name", connection.getName());
        Element bendPointsElement = doc.createElement("bendPoints");
        element.appendChild(bendPointsElement);
        for (Position bendPoint : connection.getBendPoints()) {
            this.addPosition(bendPointsElement, bendPoint, "bendPoint");
        }
        this.addTextElement(element, "labelIndex", connection.getLabelIndex());
        this.addTextElement(element, "zIndex", connection.getZIndex());
        String sourceId = connection.getSource().getIdentifier();
        ConnectableType sourceType = connection.getSource().getConnectableType();
        String sourceGroupId = sourceType == ConnectableType.REMOTE_OUTPUT_PORT ? ((RemoteGroupPort)connection.getSource()).getRemoteProcessGroup().getIdentifier() : connection.getSource().getProcessGroup().getIdentifier();
        ConnectableType destinationType = connection.getDestination().getConnectableType();
        String destinationId = connection.getDestination().getIdentifier();
        String destinationGroupId = destinationType == ConnectableType.REMOTE_INPUT_PORT ? ((RemoteGroupPort)connection.getDestination()).getRemoteProcessGroup().getIdentifier() : connection.getDestination().getProcessGroup().getIdentifier();
        this.addTextElement(element, "sourceId", sourceId);
        this.addTextElement(element, "sourceGroupId", sourceGroupId);
        this.addTextElement(element, "sourceType", sourceType.toString());
        this.addTextElement(element, "destinationId", destinationId);
        this.addTextElement(element, "destinationGroupId", destinationGroupId);
        this.addTextElement(element, "destinationType", destinationType.toString());
        for (Relationship relationship : connection.getRelationships()) {
            this.addTextElement(element, "relationship", relationship.getName());
        }
        this.addTextElement(element, "maxWorkQueueSize", connection.getFlowFileQueue().getBackPressureObjectThreshold());
        this.addTextElement(element, "maxWorkQueueDataSize", connection.getFlowFileQueue().getBackPressureDataSizeThreshold());
        this.addTextElement(element, "flowFileExpiration", connection.getFlowFileQueue().getFlowFileExpiration());
        for (FlowFilePrioritizer comparator : connection.getFlowFileQueue().getPriorities()) {
            String className = comparator.getClass().getCanonicalName();
            this.addTextElement(element, "queuePrioritizerClass", className);
        }
        parentElement.appendChild(element);
    }

    private void addTextElement(Element element, String name, long value) {
        this.addTextElement(element, name, String.valueOf(value));
    }

    private void addTextElement(Element element, String name, String value) {
        Document doc = element.getOwnerDocument();
        Element toAdd = doc.createElement(name);
        toAdd.setTextContent(value);
        element.appendChild(toAdd);
    }
}

