/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.StandardPropertyValue;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.Severity;

public class StandardReportingContext
implements ReportingContext,
ControllerServiceLookup {
    private final FlowController flowController;
    private final EventAccess eventAccess;
    private final BulletinRepository bulletinRepository;
    private final ControllerServiceProvider serviceProvider;
    private final Map<PropertyDescriptor, String> properties;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;

    public StandardReportingContext(FlowController flowController, BulletinRepository bulletinRepository, Map<PropertyDescriptor, String> properties, ControllerServiceProvider serviceProvider) {
        this.flowController = flowController;
        this.eventAccess = flowController;
        this.bulletinRepository = bulletinRepository;
        this.properties = Collections.unmodifiableMap(properties);
        this.serviceProvider = serviceProvider;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public EventAccess getEventAccess() {
        return this.eventAccess;
    }

    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    public Bulletin createBulletin(String category, Severity severity, String message) {
        return BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
    }

    public Bulletin createBulletin(String componentId, String category, Severity severity, String message) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        Connectable connectable = rootGroup.findConnectable(componentId);
        if (connectable == null) {
            throw new IllegalStateException("Cannot create Component-Level Bulletin because no component can be found with ID " + componentId);
        }
        return BulletinFactory.createBulletin((Connectable)connectable, (String)category, (String)severity.name(), (String)message);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.properties.get(property);
        return new StandardPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, this, this.preparedQueries.get(property));
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.serviceProvider.getControllerService(serviceIdentifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.serviceProvider.getControllerServiceIdentifiers(serviceType);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.serviceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }
}

