/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.controller.AbstractConfiguredComponent;
import org.apache.nifi.controller.Availability;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.annotation.OnConfigured;
import org.apache.nifi.controller.exception.ProcessorLifeCycleException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceReference;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.util.ReflectionUtils;

public class StandardControllerServiceNode
extends AbstractConfiguredComponent
implements ControllerServiceNode {
    private final ControllerService proxedControllerService;
    private final ControllerService implementation;
    private final ControllerServiceProvider serviceProvider;
    private final AtomicReference<Availability> availability = new AtomicReference<Availability>(Availability.NODE_ONLY);
    private final AtomicBoolean disabled = new AtomicBoolean(true);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<ConfiguredComponent> referencingComponents = new HashSet<ConfiguredComponent>();

    public StandardControllerServiceNode(ControllerService proxiedControllerService, ControllerService implementation, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider) {
        super((ConfigurableComponent)proxiedControllerService, id, validationContextFactory, serviceProvider);
        this.proxedControllerService = proxiedControllerService;
        this.implementation = implementation;
        this.serviceProvider = serviceProvider;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public void setDisabled(boolean disabled) {
        Set runningRefs;
        if (!disabled && !this.isValid()) {
            throw new IllegalStateException("Cannot enable Controller Service " + this.implementation + " because it is not valid");
        }
        if (disabled && !(runningRefs = this.getReferences().getRunningReferences()).isEmpty()) {
            throw new IllegalStateException("Cannot disable Controller Service because it is referenced (either directly or indirectly) by " + runningRefs.size() + " different components that are currently running");
        }
        this.disabled.set(disabled);
    }

    public Availability getAvailability() {
        return this.availability.get();
    }

    public void setAvailability(Availability availability) {
        this.availability.set(availability);
    }

    public ControllerService getProxiedControllerService() {
        return this.proxedControllerService;
    }

    public ControllerService getControllerServiceImplementation() {
        return this.implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControllerServiceReference getReferences() {
        this.readLock.lock();
        try {
            StandardControllerServiceReference standardControllerServiceReference = new StandardControllerServiceReference(this, this.referencingComponents);
            return standardControllerServiceReference;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.add(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.remove(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (!this.isDisabled()) {
            throw new IllegalStateException("Cannot modify Controller Service configuration because it is currently enabled. Please disable the Controller Service first.");
        }
    }

    public void setProperty(String name, String value) {
        super.setProperty(name, value);
        this.onConfigured();
    }

    public boolean removeProperty(String name) {
        boolean removed = super.removeProperty(name);
        if (removed) {
            this.onConfigured();
        }
        return removed;
    }

    private void onConfigured() {
        try (NarCloseable x = NarCloseable.withNarLoader();){
            StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)this, (ControllerServiceLookup)this.serviceProvider);
            ReflectionUtils.invokeMethodsWithAnnotation(OnConfigured.class, this.implementation, configContext);
        }
        catch (Exception e) {
            throw new ProcessorLifeCycleException("Failed to invoke On-Configured Lifecycle methods of " + this.implementation, (Throwable)e);
        }
    }

    public void verifyCanDelete() {
        if (!this.isDisabled()) {
            throw new IllegalStateException(this.implementation + " cannot be deleted because it is not disabled");
        }
    }

    public void verifyCanDisable() {
        ControllerServiceReference references = this.getReferences();
        int numRunning = references.getRunningReferences().size();
        if (numRunning > 0) {
            throw new IllegalStateException(this.implementation + " cannot be disabled because it is referenced by " + numRunning + " components that are currently running");
        }
    }

    public void verifyCanEnable() {
        if (!this.isDisabled()) {
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not disabled");
        }
    }

    public void verifyCanUpdate() {
        if (!this.isDisabled()) {
            throw new IllegalStateException(this.implementation + " cannot be updated because it is not disabled");
        }
    }
}

