/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.exception.ControllerServiceAlreadyExistsException;
import org.apache.nifi.controller.exception.ControllerServiceNotFoundException;
import org.apache.nifi.controller.exception.ProcessorLifeCycleException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceInitializationContext;
import org.apache.nifi.controller.service.StandardControllerServiceNode;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.util.ObjectHolder;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceProvider
implements ControllerServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardControllerServiceProvider.class);
    private final Map<String, ControllerServiceNode> controllerServices = new ConcurrentHashMap<String, ControllerServiceNode>();
    private static final Set<Method> validDisabledMethods;

    private Class<?>[] getInterfaces(Class<?> cls) {
        ArrayList allIfcs = new ArrayList();
        this.populateInterfaces(cls, allIfcs);
        return allIfcs.toArray(new Class[allIfcs.size()]);
    }

    private void populateInterfaces(Class<?> cls, List<Class<?>> interfacesDefinedThusFar) {
        Class<?> superClass;
        Class<?>[] ifc = cls.getInterfaces();
        if (ifc != null && ifc.length > 0) {
            for (Class<?> i : ifc) {
                interfacesDefinedThusFar.add(i);
            }
        }
        if ((superClass = cls.getSuperclass()) != null) {
            this.populateInterfaces(superClass, interfacesDefinedThusFar);
        }
    }

    public ControllerServiceNode createControllerService(String type, final String id, boolean firstTimeAdded) {
        if (type == null || id == null) {
            throw new NullPointerException();
        }
        if (this.controllerServices.containsKey(id)) {
            throw new ControllerServiceAlreadyExistsException(id);
        }
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = ExtensionManager.getClassLoader((String)type);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> rawClass = Class.forName(type, false, cl);
            Class<ControllerService> controllerServiceClass = rawClass.asSubclass(ControllerService.class);
            final ControllerService originalService = controllerServiceClass.newInstance();
            final ObjectHolder serviceNodeHolder = new ObjectHolder(null);
            InvocationHandler invocationHandler = new InvocationHandler(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    ControllerServiceNode node = (ControllerServiceNode)serviceNodeHolder.get();
                    if (node.isDisabled() && !validDisabledMethods.contains(method)) {
                        try {
                            NarCloseable narCloseable = NarCloseable.withNarLoader();
                            Throwable throwable = null;
                            try {
                                try {
                                    throw new IllegalStateException("Cannot invoke method " + method + " on Controller Service " + originalService + " because the Controller Service is disabled");
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable3) {
                                if (narCloseable == null) throw throwable3;
                                if (throwable == null) {
                                    narCloseable.close();
                                    throw throwable3;
                                }
                                try {
                                    narCloseable.close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                            }
                        }
                        catch (Throwable e) {
                            throw new IllegalStateException("Cannot invoke method " + method + " on Controller Service with identifier " + id + " because the Controller Service is disabled");
                        }
                    }
                    try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                        Object object = method.invoke((Object)originalService, args);
                        return object;
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
            };
            ControllerService proxiedService = (ControllerService)Proxy.newProxyInstance(cl, this.getInterfaces(controllerServiceClass), invocationHandler);
            logger.info("Loaded service {} as configured.", (Object)type);
            originalService.initialize((ControllerServiceInitializationContext)new StandardControllerServiceInitializationContext(id, this));
            StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this);
            StandardControllerServiceNode serviceNode = new StandardControllerServiceNode(proxiedService, originalService, id, validationContextFactory, this);
            serviceNodeHolder.set((Object)serviceNode);
            serviceNode.setAnnotationData(null);
            serviceNode.setName(id);
            if (firstTimeAdded) {
                try (NarCloseable x = NarCloseable.withNarLoader();){
                    ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, originalService, new Object[0]);
                }
                catch (Exception e) {
                    throw new ProcessorLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + originalService, (Throwable)e);
                }
            }
            this.controllerServices.put(id, serviceNode);
            StandardControllerServiceNode standardControllerServiceNode = serviceNode;
            return standardControllerServiceNode;
        }
        catch (Throwable t) {
            throw new ControllerServiceNotFoundException(t);
        }
        finally {
            if (currentContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
            }
        }
    }

    public void enableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanEnable();
        try (NarCloseable x = NarCloseable.withNarLoader();){
            StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)serviceNode, (ControllerServiceLookup)this);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnEnabled.class, (Object)serviceNode.getControllerServiceImplementation(), configContext);
        }
        serviceNode.setDisabled(false);
    }

    public void disableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanDisable();
        serviceNode.setDisabled(true);
        try (NarCloseable x = NarCloseable.withNarLoader();){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnDisabled.class, (Object)serviceNode.getControllerServiceImplementation(), new Object[0]);
        }
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        ControllerServiceNode node = this.controllerServices.get(serviceIdentifier);
        return node == null ? null : node.getProxiedControllerService();
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.isControllerServiceEnabled(service.getIdentifier());
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        ControllerServiceNode node = this.controllerServices.get(serviceIdentifier);
        return node == null ? false : !node.isDisabled();
    }

    public ControllerServiceNode getControllerServiceNode(String serviceIdentifier) {
        return this.controllerServices.get(serviceIdentifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        HashSet<String> identifiers = new HashSet<String>();
        for (Map.Entry<String, ControllerServiceNode> entry : this.controllerServices.entrySet()) {
            if (!Objects.requireNonNull(serviceType).isAssignableFrom(entry.getValue().getProxiedControllerService().getClass())) continue;
            identifiers.add(entry.getKey());
        }
        return identifiers;
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        ControllerServiceNode existing = this.controllerServices.get(serviceNode.getIdentifier());
        if (existing == null || existing != serviceNode) {
            throw new IllegalStateException("Controller Service " + serviceNode + " does not exist in this Flow");
        }
        serviceNode.verifyCanDelete();
        try (NarCloseable x = NarCloseable.withNarLoader();){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ConfiguredComponent)serviceNode, (ControllerServiceLookup)this);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)serviceNode.getControllerServiceImplementation(), configurationContext);
        }
        this.controllerServices.remove(serviceNode.getIdentifier());
    }

    static {
        HashSet<Method> validMethods = new HashSet<Method>();
        for (Method method : ControllerService.class.getMethods()) {
            validMethods.add(method);
        }
        for (Method method : Object.class.getMethods()) {
            validMethods.add(method);
        }
        validDisabledMethods = Collections.unmodifiableSet(validMethods);
    }
}

