/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.web.api.dto.status.StatusDescriptorDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.dto.status.StatusSnapshotDTO;

public class StatusHistoryUtil {
    public static StatusHistoryDTO createStatusHistoryDTO(StatusHistory statusHistory) {
        ArrayList<StatusSnapshotDTO> snapshotDtos = new ArrayList<StatusSnapshotDTO>();
        LinkedHashSet metricDescriptors = new LinkedHashSet();
        LinkedHashMap componentDetails = new LinkedHashMap(statusHistory.getComponentDetails());
        for (StatusSnapshot snapshot : statusHistory.getStatusSnapshots()) {
            snapshotDtos.add(StatusHistoryUtil.createStatusSnapshotDto(snapshot));
            metricDescriptors.addAll(snapshot.getStatusMetrics().keySet());
        }
        StatusHistoryDTO dto = new StatusHistoryDTO();
        dto.setGenerated(new Date());
        dto.setDetails(componentDetails);
        dto.setFieldDescriptors(StatusHistoryUtil.createFieldDescriptorDtos(metricDescriptors));
        dto.setStatusSnapshots(snapshotDtos);
        return dto;
    }

    public static StatusDescriptorDTO createStatusDescriptorDto(MetricDescriptor<?> metricDescriptor) {
        StatusDescriptorDTO dto = new StatusDescriptorDTO();
        dto.setDescription(metricDescriptor.getDescription());
        dto.setField(metricDescriptor.getField());
        dto.setFormatter(metricDescriptor.getFormatter().name());
        dto.setLabel(metricDescriptor.getLabel());
        return dto;
    }

    public static List<StatusDescriptorDTO> createFieldDescriptorDtos(Collection<MetricDescriptor<?>> metricDescriptors) {
        ArrayList<StatusDescriptorDTO> dtos = new ArrayList<StatusDescriptorDTO>();
        LinkedHashSet allDescriptors = new LinkedHashSet();
        for (MetricDescriptor<?> metricDescriptor : metricDescriptors) {
            allDescriptors.add(metricDescriptor);
        }
        for (MetricDescriptor metricDescriptor : allDescriptors) {
            dtos.add(StatusHistoryUtil.createStatusDescriptorDto(metricDescriptor));
        }
        return dtos;
    }

    public static List<StatusDescriptorDTO> createFieldDescriptorDtos(StatusHistory statusHistory) {
        ArrayList<StatusDescriptorDTO> dtos = new ArrayList<StatusDescriptorDTO>();
        LinkedHashSet<MetricDescriptor> allDescriptors = new LinkedHashSet<MetricDescriptor>();
        for (StatusSnapshot statusSnapshot : statusHistory.getStatusSnapshots()) {
            for (MetricDescriptor metricDescriptor : statusSnapshot.getStatusMetrics().keySet()) {
                allDescriptors.add(metricDescriptor);
            }
        }
        for (MetricDescriptor metricDescriptor : allDescriptors) {
            dtos.add(StatusHistoryUtil.createStatusDescriptorDto(metricDescriptor));
        }
        return dtos;
    }

    public static StatusSnapshotDTO createStatusSnapshotDto(StatusSnapshot statusSnapshot) {
        StatusSnapshotDTO dto = new StatusSnapshotDTO();
        dto.setTimestamp(statusSnapshot.getTimestamp());
        HashMap statusMetrics = new HashMap();
        for (Map.Entry entry : statusSnapshot.getStatusMetrics().entrySet()) {
            statusMetrics.put(((MetricDescriptor)entry.getKey()).getField(), entry.getValue());
        }
        dto.setStatusMetrics(statusMetrics);
        return dto;
    }
}

