/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.tasks;

import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.scheduling.ScheduleState;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.annotation.OnStopped;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingTaskWrapper
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ReportingTaskWrapper.class);
    private final ReportingTaskNode taskNode;
    private final ScheduleState scheduleState;

    public ReportingTaskWrapper(ReportingTaskNode taskNode, ScheduleState scheduleState) {
        this.taskNode = taskNode;
        this.scheduleState = scheduleState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void run() {
        block58: {
            block55: {
                this.scheduleState.incrementActiveThreadCount();
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    this.taskNode.getReportingTask().onTrigger(this.taskNode.getReportingContext());
                }
                if (this.scheduleState.isScheduled() || this.scheduleState.getActiveThreadCount() != 1 || !this.scheduleState.mustCallOnStoppedMethods()) break block55;
                var2_4 = null;
                try (NarCloseable x = NarCloseable.withNarLoader();){
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(org.apache.nifi.annotation.lifecycle.OnStopped.class, OnStopped.class, this.taskNode.getReportingTask(), this.taskNode.getReportingContext());
                }
                catch (Throwable x2) {
                    var2_4 = x2;
                    throw x2;
                }
            }
            this.scheduleState.decrementActiveThreadCount();
            break block58;
            catch (Throwable t) {
                block56: {
                    try {
                        logger.error("Error running task {} due to {}", (Object)this.taskNode.getReportingTask(), (Object)t.toString());
                        if (logger.isDebugEnabled()) {
                            logger.error("", t);
                        }
                        if (this.scheduleState.isScheduled() || this.scheduleState.getActiveThreadCount() != 1 || !this.scheduleState.mustCallOnStoppedMethods()) break block56;
                    }
                    catch (Throwable throwable) {
                        if (!this.scheduleState.isScheduled() && this.scheduleState.getActiveThreadCount() == 1 && this.scheduleState.mustCallOnStoppedMethods()) {
                            try (NarCloseable x = NarCloseable.withNarLoader();){
                                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(org.apache.nifi.annotation.lifecycle.OnStopped.class, OnStopped.class, this.taskNode.getReportingTask(), this.taskNode.getReportingContext());
                            }
                        }
                        this.scheduleState.decrementActiveThreadCount();
                        throw throwable;
                    }
                    try (NarCloseable x = NarCloseable.withNarLoader();){
                        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(org.apache.nifi.annotation.lifecycle.OnStopped.class, OnStopped.class, this.taskNode.getReportingTask(), this.taskNode.getReportingContext());
                    }
                }
                this.scheduleState.decrementActiveThreadCount();
            }
        }
    }
}

